/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.csv;

import java.io.IOException;
import java.io.Writer;
import org.beanio.stream.RecordWriter;
import org.beanio.stream.csv.CsvParserConfiguration;

public class CsvWriter
implements RecordWriter {
    private char delim = (char)44;
    private char quote = (char)34;
    private char endQuote = (char)34;
    private char escapeChar = (char)34;
    private String lineSeparator;
    private boolean alwaysQuote = false;
    private transient Writer out;
    private transient int lineNumber;

    public CsvWriter(Writer out) {
        this(out, null);
    }

    public CsvWriter(Writer out, CsvParserConfiguration config) {
        if (config == null) {
            config = new CsvParserConfiguration();
        }
        this.out = out;
        this.delim = config.getDelimiter();
        this.quote = config.getQuote();
        this.endQuote = config.getQuote();
        this.alwaysQuote = config.isAlwaysQuote();
        this.escapeChar = config.getEscape().charValue();
        this.lineSeparator = config.getRecordTerminator() == null ? System.getProperty("line.separator") : config.getRecordTerminator();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void write(Object value) throws IOException {
        this.write((String[])value);
    }

    public void write(String[] record) throws IOException {
        ++this.lineNumber;
        int pos = 0;
        for (String field : record) {
            boolean quoted;
            if (pos++ > 0) {
                this.out.write(this.delim);
            }
            boolean skipLF = false;
            char[] cs = field.toCharArray();
            boolean bl = quoted = this.alwaysQuote || this.mustQuote(cs);
            if (quoted) {
                this.out.write(this.quote);
            }
            for (char c : cs) {
                if (c == this.endQuote || c == this.escapeChar) {
                    this.out.write(this.escapeChar);
                } else if (c == '\r') {
                    skipLF = true;
                    ++this.lineNumber;
                } else if (c == '\n') {
                    if (skipLF) {
                        skipLF = false;
                    } else {
                        ++this.lineNumber;
                    }
                } else {
                    skipLF = false;
                }
                this.out.write(c);
            }
            if (!quoted) continue;
            this.out.write(this.endQuote);
        }
        this.out.write(this.lineSeparator);
    }

    private boolean mustQuote(char[] cs) {
        for (char c : cs) {
            if (c == this.delim) {
                return true;
            }
            if (c == this.quote) {
                return true;
            }
            if (c == '\n') {
                return true;
            }
            if (c != '\r') continue;
            return true;
        }
        return false;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

