/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    public static final String DATETIME_ALIAS = "datetime";
    public static final String DATE_ALIAS = "date";
    public static final String TIME_ALIAS = "time";
    public static final String CALENDAR_DATETIME_ALIAS = "calendar-datetime";
    public static final String CALENDAR_TIME_ALIAS = "calendar-time";
    public static final String CALENDAR_DATE_ALIAS = "calendar-date";
    public static final Class<? extends Collection<Object>> ARRAY_TYPE = ArrayCollection.class;

    private TypeUtil() {
    }

    public static boolean isAssignable(Class<?> to, Class<?> from) {
        return TypeUtil.toWrapperClass(to).isAssignableFrom(from);
    }

    public static Class<?> toWrapperClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Primitive type not supported: " + type.getName());
    }

    public static Class<?> toType(ClassLoader classLoader, String type) {
        if ("string".equalsIgnoreCase(type)) {
            return String.class;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return Boolean.class;
        }
        if ("byte".equalsIgnoreCase(type)) {
            return Byte.class;
        }
        if ("char".equalsIgnoreCase(type)) {
            return Character.class;
        }
        if ("character".equalsIgnoreCase(type)) {
            return Character.class;
        }
        if ("short".equalsIgnoreCase(type)) {
            return Short.class;
        }
        if ("int".equalsIgnoreCase(type)) {
            return Integer.class;
        }
        if ("Integer".equalsIgnoreCase(type)) {
            return Integer.class;
        }
        if ("long".equalsIgnoreCase(type)) {
            return Long.class;
        }
        if ("float".equalsIgnoreCase(type)) {
            return Float.class;
        }
        if ("double".equalsIgnoreCase(type)) {
            return Double.class;
        }
        if ("bigdecimal".equalsIgnoreCase(type)) {
            return BigDecimal.class;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return BigDecimal.class;
        }
        if ("biginteger".equalsIgnoreCase(type)) {
            return BigInteger.class;
        }
        if ("uuid".equalsIgnoreCase(type)) {
            return UUID.class;
        }
        if ("url".equalsIgnoreCase(type)) {
            return URL.class;
        }
        if ("calendar".equalsIgnoreCase(type) || CALENDAR_DATE_ALIAS.equalsIgnoreCase(type) || CALENDAR_TIME_ALIAS.equalsIgnoreCase(type) || CALENDAR_DATETIME_ALIAS.equalsIgnoreCase(type)) {
            return Calendar.class;
        }
        if (DATE_ALIAS.equalsIgnoreCase(type) || TIME_ALIAS.equalsIgnoreCase(type) || DATETIME_ALIAS.equalsIgnoreCase(type)) {
            return Date.class;
        }
        try {
            return classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isAliasOnly(String alias) {
        return DATE_ALIAS.equalsIgnoreCase(alias) || TIME_ALIAS.equalsIgnoreCase(alias) || CALENDAR_DATE_ALIAS.equalsIgnoreCase(alias) || CALENDAR_TIME_ALIAS.equalsIgnoreCase(alias);
    }

    public static Class<? extends Collection<Object>> toCollectionType(String type) {
        if ("array".equalsIgnoreCase(type)) {
            return ARRAY_TYPE;
        }
        if ("collection".equalsIgnoreCase(type)) {
            return Collection.class;
        }
        if ("list".equalsIgnoreCase(type)) {
            return List.class;
        }
        if ("set".equalsIgnoreCase(type)) {
            return Set.class;
        }
        try {
            Class<?> clazz = Class.forName(type);
            if (!Collection.class.isAssignableFrom(clazz)) {
                return null;
            }
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Class<?> toAggregationType(String type) {
        if ("array".equalsIgnoreCase(type)) {
            return ARRAY_TYPE;
        }
        if ("collection".equalsIgnoreCase(type)) {
            return Collection.class;
        }
        if ("list".equalsIgnoreCase(type)) {
            return List.class;
        }
        if ("set".equalsIgnoreCase(type)) {
            return Set.class;
        }
        if ("map".equalsIgnoreCase(type)) {
            return Map.class;
        }
        try {
            Class<?> clazz = Class.forName(type);
            if (Collection.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Class<?> toBeanType(ClassLoader classLoader, String type) {
        Class beanClass = null;
        if (type != null) {
            if ("map".equals(type)) {
                beanClass = LinkedHashMap.class;
            } else if ("list".equals(type) || "collection".equals(type)) {
                beanClass = ArrayList.class;
            } else if ("set".equals(type)) {
                beanClass = LinkedHashSet.class;
            } else {
                try {
                    beanClass = classLoader.loadClass(type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return beanClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ArrayCollection
    extends Collection<Object> {
    }
}

