/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.util.EnumTypeHandler;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.ToStringEnumTypeHandler;
import org.beanio.internal.util.TypeUtil;
import org.beanio.types.BigDecimalTypeHandler;
import org.beanio.types.BigIntegerTypeHandler;
import org.beanio.types.BooleanTypeHandler;
import org.beanio.types.ByteTypeHandler;
import org.beanio.types.CalendarTypeHandler;
import org.beanio.types.CharacterTypeHandler;
import org.beanio.types.ConfigurableTypeHandler;
import org.beanio.types.DateTypeHandler;
import org.beanio.types.DoubleTypeHandler;
import org.beanio.types.FloatTypeHandler;
import org.beanio.types.IntegerTypeHandler;
import org.beanio.types.LongTypeHandler;
import org.beanio.types.ShortTypeHandler;
import org.beanio.types.StringTypeHandler;
import org.beanio.types.TypeHandler;
import org.beanio.types.URLTypeHandler;
import org.beanio.types.UUIDTypeHandler;
import org.beanio.types.xml.XmlBooleanTypeHandler;
import org.beanio.types.xml.XmlCalendarDateTimeTypeHandler;
import org.beanio.types.xml.XmlCalendarDateTypeHandler;
import org.beanio.types.xml.XmlCalendarTimeTypeHandler;
import org.beanio.types.xml.XmlDateTimeTypeHandler;
import org.beanio.types.xml.XmlDateTypeHandler;
import org.beanio.types.xml.XmlTimeTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHandlerFactory {
    private TypeHandlerFactory parent;
    private ClassLoader classLoader;
    private Map<String, TypeHandler> handlerMap = new HashMap<String, TypeHandler>();
    private static final String NAME_KEY = "name:";
    private static final String TYPE_KEY = "type:";
    private static final TypeHandlerFactory defaultFactory = new TypeHandlerFactory(TypeHandlerFactory.class.getClassLoader());

    public TypeHandlerFactory() {
        this(TypeHandlerFactory.class.getClassLoader());
    }

    public TypeHandlerFactory(ClassLoader classLoader) {
        this.setParent(TypeHandlerFactory.getDefault());
        this.classLoader = classLoader;
    }

    public TypeHandlerFactory(ClassLoader classLoader, TypeHandlerFactory parent) {
        this.setParent(parent);
        this.classLoader = classLoader;
    }

    public TypeHandler getTypeHandler(String name) {
        return this.getTypeHandler(name, null);
    }

    public TypeHandler getTypeHandler(String name, Properties properties) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.getHandler(NAME_KEY + name, null, properties);
    }

    public TypeHandler getTypeHandlerFor(String type) {
        return this.getTypeHandlerFor(type, (String)null, (Properties)null);
    }

    public TypeHandler getTypeHandlerFor(String type, String format) {
        return this.getTypeHandlerFor(type, format, (Properties)null);
    }

    public TypeHandler getTypeHandlerFor(String type, String format, Properties properties) throws IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException();
        }
        if (TypeUtil.isAliasOnly(type)) {
            return this.getHandler(TYPE_KEY + type.toLowerCase(), format, properties);
        }
        Class<?> clazz = TypeUtil.toType(this.classLoader, type);
        if (clazz == null) {
            return null;
        }
        return this.getTypeHandlerFor(clazz, format, properties);
    }

    public TypeHandler getTypeHandlerFor(Class<?> clazz) {
        return this.getTypeHandlerFor(clazz, null, null);
    }

    public TypeHandler getTypeHandlerFor(Class<?> clazz, String format, Properties properties) throws IllegalArgumentException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        clazz = TypeUtil.toWrapperClass(clazz);
        TypeHandler handler = this.getHandler(TYPE_KEY + clazz.getName(), format, properties);
        if (handler == null && Enum.class.isAssignableFrom(clazz)) {
            return this.getEnumHandler(clazz, properties);
        }
        return handler;
    }

    private TypeHandler getEnumHandler(Class<Enum> clazz, Properties properties) {
        String format = null;
        if (properties != null) {
            format = properties.getProperty("format");
        }
        if (format == null || "name".equals(format)) {
            return new EnumTypeHandler(clazz);
        }
        if ("toString".equals(format)) {
            return new ToStringEnumTypeHandler(clazz);
        }
        throw new BeanIOConfigurationException("Invalid format '" + format + "', " + "expected 'toString' or 'name' (default)");
    }

    private TypeHandler getHandler(String key, String format, Properties properties) throws IllegalArgumentException {
        TypeHandler handler = null;
        TypeHandlerFactory factory = this;
        while (factory != null) {
            if (format != null && (handler = factory.handlerMap.get(format + "." + key)) != null) {
                return this.getHandler(handler, properties);
            }
            handler = factory.handlerMap.get(key);
            if (handler != null) {
                return this.getHandler(handler, properties);
            }
            factory = factory.parent;
        }
        return null;
    }

    private TypeHandler getHandler(TypeHandler handler, Properties properties) throws IllegalArgumentException {
        if (properties != null && !properties.isEmpty()) {
            if (handler instanceof ConfigurableTypeHandler) {
                handler = ((ConfigurableTypeHandler)handler).newInstance(properties);
            } else {
                String property = properties.keys().nextElement().toString();
                throw new IllegalArgumentException("'" + property + "' setting not supported by type handler");
            }
        }
        return handler;
    }

    public void registerHandler(String name, TypeHandler handler) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handlerMap.put(NAME_KEY + name, handler);
    }

    public void registerHandlerFor(String type, TypeHandler handler) throws IllegalArgumentException {
        this.registerHandlerFor(type, handler, null);
    }

    public void registerHandlerFor(String type, TypeHandler handler, String format) throws IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = TypeUtil.toType(this.classLoader, type);
        if (clazz == null) {
            throw new IllegalArgumentException("Invalid type or type alias '" + type + "'");
        }
        if (TypeUtil.isAliasOnly(type)) {
            type = type.toLowerCase();
            this.registerHandlerFor(format, type, clazz, handler);
        } else {
            this.registerHandlerFor(format, clazz.getName(), clazz, handler);
        }
    }

    public void registerHandlerFor(Class<?> clazz, TypeHandler handler) throws IllegalArgumentException {
        this.registerHandlerFor(clazz, handler, null);
    }

    public void registerHandlerFor(Class<?> clazz, TypeHandler handler, String format) throws IllegalArgumentException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        clazz = TypeUtil.toWrapperClass(clazz);
        this.registerHandlerFor(format, clazz.getName(), clazz, handler);
    }

    private void registerHandlerFor(String format, String type, Class<?> expectedClass, TypeHandler handler) {
        if (!TypeUtil.isAssignable(expectedClass, handler.getType())) {
            throw new IllegalArgumentException("Type handler type '" + handler.getType().getName() + "' is not assignable from configured " + "type '" + expectedClass.getName() + "'");
        }
        if (format != null) {
            this.handlerMap.put(format + "." + TYPE_KEY + type, handler);
        } else {
            this.handlerMap.put(TYPE_KEY + type, handler);
        }
    }

    public static TypeHandlerFactory getDefault() {
        return defaultFactory;
    }

    private void setParent(TypeHandlerFactory parent) {
        this.parent = parent;
    }

    static {
        defaultFactory.registerHandlerFor(Character.class, (TypeHandler)new CharacterTypeHandler());
        defaultFactory.registerHandlerFor(String.class, (TypeHandler)new StringTypeHandler());
        defaultFactory.registerHandlerFor(Byte.class, (TypeHandler)new ByteTypeHandler());
        defaultFactory.registerHandlerFor(Short.class, (TypeHandler)new ShortTypeHandler());
        defaultFactory.registerHandlerFor(Integer.class, (TypeHandler)new IntegerTypeHandler());
        defaultFactory.registerHandlerFor(Long.class, (TypeHandler)new LongTypeHandler());
        defaultFactory.registerHandlerFor(Float.class, (TypeHandler)new FloatTypeHandler());
        defaultFactory.registerHandlerFor(Double.class, (TypeHandler)new DoubleTypeHandler());
        defaultFactory.registerHandlerFor(BigDecimal.class, (TypeHandler)new BigDecimalTypeHandler());
        defaultFactory.registerHandlerFor(BigInteger.class, (TypeHandler)new BigIntegerTypeHandler());
        defaultFactory.registerHandlerFor(Boolean.class, (TypeHandler)new BooleanTypeHandler());
        defaultFactory.registerHandlerFor(UUID.class, (TypeHandler)new UUIDTypeHandler());
        defaultFactory.registerHandlerFor(URL.class, (TypeHandler)new URLTypeHandler());
        Settings settings = Settings.getInstance();
        defaultFactory.registerHandlerFor("datetime", (TypeHandler)new DateTypeHandler(settings.getProperty("org.beanio.defaultDateTimeFormat")));
        defaultFactory.registerHandlerFor("date", (TypeHandler)new DateTypeHandler(settings.getProperty("org.beanio.defaultDateFormat")){

            protected DateFormat createDefaultDateFormat() {
                return DateFormat.getDateInstance(2, this.locale);
            }
        });
        defaultFactory.registerHandlerFor("time", (TypeHandler)new DateTypeHandler(settings.getProperty("org.beanio.defaultTimeFormat")){

            protected DateFormat createDefaultDateFormat() {
                return DateFormat.getTimeInstance(2, this.locale);
            }
        });
        defaultFactory.registerHandlerFor("calendar-datetime", (TypeHandler)new CalendarTypeHandler(settings.getProperty("org.beanio.defaultDateTimeFormat")));
        defaultFactory.registerHandlerFor("calendar-date", (TypeHandler)new CalendarTypeHandler(settings.getProperty("org.beanio.defaultDateFormat")){

            protected DateFormat createDefaultDateFormat() {
                return DateFormat.getDateInstance(2, this.locale);
            }
        });
        defaultFactory.registerHandlerFor("calendar-time", (TypeHandler)new CalendarTypeHandler(settings.getProperty("org.beanio.defaultTimeFormat")){

            protected DateFormat createDefaultDateFormat() {
                return DateFormat.getTimeInstance(2, this.locale);
            }
        });
        defaultFactory.registerHandlerFor("date", (TypeHandler)new XmlDateTypeHandler(), "xml");
        defaultFactory.registerHandlerFor("datetime", (TypeHandler)new XmlDateTimeTypeHandler(), "xml");
        defaultFactory.registerHandlerFor("time", (TypeHandler)new XmlTimeTypeHandler(), "xml");
        defaultFactory.registerHandlerFor("calendar-date", (TypeHandler)new XmlCalendarDateTypeHandler(), "xml");
        defaultFactory.registerHandlerFor("calendar-datetime", (TypeHandler)new XmlCalendarDateTimeTypeHandler(), "xml");
        defaultFactory.registerHandlerFor("calendar-time", (TypeHandler)new XmlCalendarTimeTypeHandler(), "xml");
        defaultFactory.registerHandlerFor(Boolean.class, (TypeHandler)new XmlBooleanTypeHandler(), "xml");
    }
}

