/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringEnumTypeHandler
implements TypeHandler {
    private Class<Enum> type;
    private Map<String, Enum> map;

    public ToStringEnumTypeHandler(Class<Enum> type) {
        Enum[] values;
        this.type = type;
        this.map = new HashMap<String, Enum>();
        for (Enum value : values = type.getEnumConstants()) {
            this.map.put(value.toString(), value);
        }
    }

    @Override
    public Object parse(String text) throws TypeConversionException {
        if (text == null || "".equals(text)) {
            return null;
        }
        Enum value = this.map.get(text);
        if (value == null) {
            throw new TypeConversionException("Invalid " + this.getType().getSimpleName() + " enum value '" + text + "'");
        }
        return value;
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

