/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class RecordFilterReader
extends FilterReader {
    private int lineNumber = 1;
    private long position = 0L;
    private StringBuilder record;
    private boolean skipLF = false;
    private int mark = -1;

    public RecordFilterReader(Reader in) {
        super(in);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long getPosition() {
        return this.position;
    }

    public void recordStarted() {
        this.record = new StringBuilder();
    }

    public void recordStarted(String text) {
        this.record = new StringBuilder(text);
    }

    public String recordCompleted() throws IllegalStateException {
        if (this.record == null) {
            throw new IllegalStateException("recordStarted() not called");
        }
        String text = this.record.toString();
        this.record = null;
        return text;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            char c = (char)n;
            if (this.record != null) {
                this.record.append(c);
            }
            switch (c) {
                case '\n': {
                    if (this.skipLF) {
                        this.skipLF = false;
                        break;
                    }
                    ++this.lineNumber;
                    this.position = 0L;
                    break;
                }
                case '\r': {
                    this.skipLF = true;
                    ++this.lineNumber;
                    this.position = 0L;
                    break;
                }
                default: {
                    ++this.position;
                }
            }
        }
        return n;
    }

    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
        this.mark = this.record == null ? -1 : this.record.length();
    }

    public void reset() throws IOException {
        super.reset();
        if (this.mark < 0) {
            this.record = null;
        } else {
            this.record.setLength(this.mark);
        }
    }
}

