/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.beanio.BeanIOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomUtil {
    private static final DocumentBuilder domFactory;

    private DomUtil() {
    }

    public static Document newDocument() {
        return domFactory.newDocument();
    }

    public static void print(String title, Node document) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer trans = factory.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(document);
            trans.transform(source, result);
            System.out.println("--" + title + "--------------------------------");
            System.out.print(sw.toString());
            System.out.println("-------------------------------------------");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            DocumentBuilderFactory domBuilderFactory = DocumentBuilderFactory.newInstance();
            domBuilderFactory.setIgnoringComments(true);
            domBuilderFactory.setCoalescing(true);
            domBuilderFactory.setNamespaceAware(true);
            domBuilderFactory.setValidating(false);
            domFactory = domBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new BeanIOException(ex);
        }
    }
}

