/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.util.Debuggable;

public class DebugUtil {
    private DebugUtil() {
    }

    public static String formatRange(int min, int max) {
        if (max == Integer.MAX_VALUE) {
            return min + "+";
        }
        return min + "-" + max;
    }

    public static String formatOption(String option, boolean value) {
        if (value) {
            return option;
        }
        return "!" + option;
    }

    public static String formatPadding(FieldPadding padding) {
        if (padding == null) {
            return "";
        }
        return ", padded[length=" + padding.getLength() + ", filler=" + padding.getFiller() + ", align=" + padding.getJustify() + "]";
    }

    public static String toString(Debuggable c) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            c.debug(new PrintStream(out));
            return new String(out.toByteArray(), "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

