/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.TypeHandlerFactory;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

public class BeanUtil {
    private static final boolean NULL_ESCAPING_ENABLED = "true".equalsIgnoreCase(Settings.getInstance().getProperty("org.beanio.propertyEscapingEnabled"));
    private static final TypeHandlerFactory typeHandlerFactory = new TypeHandlerFactory(BeanUtil.class.getClassLoader());

    private BeanUtil() {
    }

    public static Object createBean(ClassLoader classLoader, String className, Properties props) {
        Object bean = BeanUtil.createBean(classLoader, className);
        BeanUtil.configure(bean, props);
        return bean;
    }

    public static Object createBean(ClassLoader classLoader, String className) {
        if (className == null) {
            throw new BeanIOConfigurationException("Class not set");
        }
        if (className.startsWith("org.beanio.")) {
            classLoader = BeanUtil.class.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new BeanIOConfigurationException("Class not found '" + className + "'", e);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new BeanIOConfigurationException("Cound not instantiate class '" + clazz + "'", e);
        }
    }

    public static void configure(Object bean, Properties props) {
        BeanInfo info;
        if (props == null || props.isEmpty()) {
            return;
        }
        Class<?> clazz = bean.getClass();
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanIOConfigurationException(e);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            PropertyDescriptor descriptor = null;
            int j = descriptors.length;
            for (int i = 0; i < j; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                descriptor = descriptors[i];
                break;
            }
            if (descriptor == null) {
                throw new BeanIOConfigurationException("Property '" + name + "' not found on class '" + clazz + "'");
            }
            Method method = descriptor.getWriteMethod();
            if (method == null) {
                throw new BeanIOConfigurationException("Property '" + name + "' is not writeable on class '" + clazz + "'");
            }
            String valueText = (String)entry.getValue();
            Class<?> propertyClass = descriptor.getPropertyType();
            TypeHandler typeHandler = typeHandlerFactory.getTypeHandlerFor(propertyClass);
            if (typeHandler == null) {
                throw new BeanIOConfigurationException("Property type '" + propertyClass + "' not supported for property '" + name + "' on class '" + clazz + "'");
            }
            try {
                Object value = typeHandler.parse(valueText);
                if (value == null && propertyClass.isPrimitive()) continue;
                method.invoke(bean, value);
            }
            catch (TypeConversionException e) {
                throw new BeanIOConfigurationException("Type conversion failed for property '" + name + "' on class '" + clazz + "': " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new BeanIOConfigurationException("Failed to invoke '" + method + "' on class '" + clazz + "'", e);
            }
        }
    }

    static {
        typeHandlerFactory.registerHandlerFor(String[].class, (TypeHandler)new StringArrayTypeHandler());
        if ("true".equals(Settings.getInstance().getProperty("org.beanio.propertyEscapingEnabled"))) {
            typeHandlerFactory.registerHandlerFor(String.class, (TypeHandler)new EscapedStringTypeHandler());
            typeHandlerFactory.registerHandlerFor(Character.class, (TypeHandler)new EscapedCharacterTypeHandler());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringArrayTypeHandler
    implements TypeHandler {
        private StringArrayTypeHandler() {
        }

        public String[] parse(String text) throws TypeConversionException {
            char[] ca;
            if (text == null || "".equals(text)) {
                return null;
            }
            int pos = text.indexOf(44);
            if (pos < 0) {
                return new String[]{text};
            }
            boolean escaped = false;
            StringBuilder item = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            for (char c : ca = text.toCharArray()) {
                if (escaped) {
                    item.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == ',') {
                    list.add(item.toString());
                    item = new StringBuilder();
                    continue;
                }
                item.append(c);
            }
            list.add(item.toString());
            String[] result = new String[list.size()];
            list.toArray(result);
            return result;
        }

        @Override
        public String format(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getType() {
            return String[].class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EscapedStringTypeHandler
    implements TypeHandler {
        private EscapedStringTypeHandler() {
        }

        @Override
        public String parse(String text) throws TypeConversionException {
            if (text == null) {
                return text;
            }
            int n = text.indexOf(92);
            if (n < 0) {
                return text;
            }
            int len = text.length();
            boolean escaped = false;
            StringBuilder value = new StringBuilder(len).append(text.substring(0, n));
            for (int i = n; i < len; ++i) {
                char c = text.charAt(i);
                if (escaped) {
                    switch (c) {
                        case 'n': {
                            value.append('\n');
                            break;
                        }
                        case 'r': {
                            value.append('\r');
                            break;
                        }
                        case 't': {
                            value.append('\t');
                            break;
                        }
                        case 'f': {
                            value.append('\f');
                            break;
                        }
                        case '0': {
                            if (NULL_ESCAPING_ENABLED) {
                                value.append('\u0000');
                                break;
                            }
                            value.append(c);
                            break;
                        }
                        default: {
                            value.append(c);
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                value.append(c);
            }
            return value.toString();
        }

        @Override
        public String format(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EscapedCharacterTypeHandler
    implements TypeHandler {
        private EscapedCharacterTypeHandler() {
        }

        @Override
        public Character parse(String text) throws TypeConversionException {
            if (text == null) {
                return null;
            }
            if (text.length() == 1) {
                return Character.valueOf(text.charAt(0));
            }
            if ("\\".equals(text)) {
                return Character.valueOf('\\');
            }
            if ("\\n".equals(text)) {
                return Character.valueOf('\n');
            }
            if ("\\r".equals(text)) {
                return Character.valueOf('\r');
            }
            if ("\\t".equals(text)) {
                return Character.valueOf('\t');
            }
            if ("\\f".equals(text)) {
                return Character.valueOf('\f');
            }
            if (NULL_ESCAPING_ENABLED && "\\0".equals(text)) {
                return Character.valueOf('\u0000');
            }
            throw new TypeConversionException("Invalid character '" + text + "'");
        }

        @Override
        public String format(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getType() {
            return Character.class;
        }
    }
}

