/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.message;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.beanio.internal.parser.MessageFactory;

public class ResourceBundleMessageFactory
implements MessageFactory {
    private static final String LABEL_MESSAGE_PREFIX = "label";
    private static final String FIELD_ERROR_MESSAGE_PREFIX = "fielderror";
    private static final String RECORD_ERROR_MESSAGE_PREFIX = "recorderror";
    private ResourceBundle resourceBundle;
    private ResourceBundle defaultResourceBundle;
    private ConcurrentHashMap<String, String> messageCache = new ConcurrentHashMap();
    private static final String NOT_FOUND = new String();

    public String getRecordLabel(String recordName) {
        return this.getLabel("label." + recordName);
    }

    public String getFieldLabel(String recordName, String fieldName) {
        return this.getLabel("label." + recordName + "." + fieldName);
    }

    protected String getLabel(String key) {
        String label = this.messageCache.get(key);
        if (label != null) {
            return label == NOT_FOUND ? null : label;
        }
        if (this.resourceBundle != null) {
            label = this.getMessage(this.resourceBundle, key);
        }
        if (label == null) {
            this.messageCache.putIfAbsent(key, NOT_FOUND);
            return null;
        }
        this.messageCache.putIfAbsent(key, label);
        return label;
    }

    public String getFieldErrorMessage(String recordName, String fieldName, String rule) {
        String key = "fielderror." + recordName + "." + fieldName + "." + rule;
        String message = this.messageCache.get(key);
        if (message != null) {
            return message == NOT_FOUND ? key : message;
        }
        String k = key;
        if (this.resourceBundle != null && (message = this.getMessage(this.resourceBundle, k)) == null && (message = this.getMessage(this.resourceBundle, k = "fielderror." + recordName + "." + rule)) == null) {
            k = "fielderror." + rule;
            message = this.getMessage(this.resourceBundle, k);
        }
        if (message == null && this.defaultResourceBundle != null) {
            message = this.getMessage(this.defaultResourceBundle, "fielderror." + rule);
        }
        if (message == null) {
            this.messageCache.putIfAbsent(key, NOT_FOUND);
            return key;
        }
        this.messageCache.putIfAbsent(key, message);
        return message;
    }

    public String getRecordErrorMessage(String recordName, String rule) {
        String key = "recorderror." + recordName + "." + rule;
        String message = this.messageCache.get(key);
        if (message != null) {
            return message == NOT_FOUND ? key : message;
        }
        if (this.resourceBundle != null && (message = this.getMessage(this.resourceBundle, key)) == null) {
            message = this.getMessage(this.resourceBundle, "recorderror." + rule);
        }
        if (message == null && this.defaultResourceBundle != null) {
            message = this.getMessage(this.defaultResourceBundle, "recorderror." + rule);
        }
        if (message == null) {
            this.messageCache.putIfAbsent(key, NOT_FOUND);
            return key;
        }
        this.messageCache.putIfAbsent(key, message);
        return message;
    }

    private String getMessage(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setDefaultResourceBundle(ResourceBundle defaultResourceBundle) {
        this.defaultResourceBundle = defaultResourceBundle;
    }
}

