/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import java.io.IOException;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNode;
import org.beanio.internal.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlMarshallingContext
extends MarshallingContext {
    private boolean streaming = false;
    protected Document document;
    protected Node parent;
    private XmlNode[] groupStack;
    private int groupStackCount = 0;
    private int ungroup = 0;

    public XmlMarshallingContext(int groupDepth) {
        this.groupStack = new XmlNode[groupDepth];
    }

    public void clear() {
        this.setDocument(null);
    }

    public Object getRecordObject() {
        return this.getDocument();
    }

    public void writeRecord() throws IOException {
        super.clear();
        for (int i = 0; i < this.ungroup; ++i) {
            this.getRecordWriter().write(null);
        }
        this.ungroup = 0;
        super.writeRecord();
    }

    public Document getDocument() {
        return this.document;
    }

    private void setDocument(Document document) {
        this.document = document;
        this.parent = document;
    }

    public void openGroup(XmlNode node) {
        this.groupStack[this.groupStackCount++] = node;
    }

    public void closeGroup(XmlNode node) {
        ++this.ungroup;
    }

    public Node getParent() {
        if (this.parent == null) {
            this.document = DomUtil.newDocument();
            this.parent = this.document;
            if (this.groupStackCount > 0) {
                for (int i = this.groupStackCount - 1; i >= 0; --i) {
                    XmlNode xml = this.groupStack[i];
                    Node node = this.parent.appendChild(this.document.createElementNS(xml.getNamespace(), xml.getLocalName()));
                    node.setPrefix(xml.getPrefix());
                    node.setUserData("isGroup", Boolean.TRUE, null);
                    if (!xml.isNamespaceAware()) {
                        node.setUserData("isNamespaceIgnored", Boolean.TRUE, null);
                    } else if ("".equals(xml.getPrefix())) {
                        node.setUserData("isDefaultNamespace", Boolean.TRUE, null);
                    } else {
                        node.setPrefix(xml.getPrefix());
                    }
                    this.parent = node;
                }
                this.groupStackCount = 0;
            }
        }
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Document toDocument(Object record) {
        return (Document)record;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isStreaming() {
        return this.streaming;
    }
}

