/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.xml.XmlFieldFormat;
import org.beanio.internal.parser.format.xml.XmlMarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNodeUtil;
import org.beanio.internal.parser.format.xml.XmlUnmarshallingContext;
import org.beanio.internal.util.DebugUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlElementField
extends XmlFieldFormat {
    private boolean repeating = false;
    private String localName;
    private String prefix;
    private String namespace;
    private boolean namespaceAware;
    private boolean nillable;

    public String extractText(XmlUnmarshallingContext context) {
        Element node = context.findElement(this);
        if (node == null) {
            return null;
        }
        if (XmlNodeUtil.isNil(node)) {
            return Value.NIL;
        }
        String fieldText = XmlNodeUtil.getText(node);
        if (fieldText == null) {
            fieldText = "";
        }
        return fieldText;
    }

    public void insertText(XmlMarshallingContext ctx, String fieldText) {
        if (fieldText == null && this.isLazy()) {
            return;
        }
        if (fieldText == Value.NIL) {
            fieldText = null;
        }
        Document document = ctx.getDocument();
        Element element = document.createElementNS(this.getNamespace(), this.getLocalName());
        if (!this.isNamespaceAware()) {
            element.setUserData("isNamespaceIgnored", Boolean.TRUE, null);
        } else if ("".equals(this.getPrefix())) {
            element.setUserData("isDefaultNamespace", Boolean.TRUE, null);
        } else {
            element.setPrefix(this.getPrefix());
        }
        if (fieldText == null && this.isNillable()) {
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else if (fieldText != null && fieldText.length() > 0) {
            element.appendChild(document.createTextNode(fieldText));
        }
        Element parent = (Element)ctx.getParent();
        parent.appendChild(element);
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public int getType() {
        return 2;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", localName=").append(this.localName);
        if (this.prefix != null) {
            s.append(", prefix=").append(this.prefix);
        }
        if (this.namespace != null) {
            s.append(", xmlns=").append(this.isNamespaceAware() ? this.namespace : "*");
        }
        s.append(", ").append(DebugUtil.formatOption("nillable", this.nillable));
    }
}

