/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import org.beanio.internal.parser.format.xml.XmlFieldFormat;
import org.beanio.internal.parser.format.xml.XmlMarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNodeUtil;
import org.beanio.internal.parser.format.xml.XmlUnmarshallingContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XmlAttributeField
extends XmlFieldFormat {
    private String localName;
    private String prefix;
    private String namespace;
    private boolean namespaceAware;

    public String extractText(XmlUnmarshallingContext context) {
        Element parent = context.getPosition();
        if (parent == null) {
            return null;
        }
        return XmlNodeUtil.getAttribute(parent, this);
    }

    public void insertText(XmlMarshallingContext ctx, String fieldText) {
        Element parent = (Element)ctx.getParent();
        String text = fieldText;
        if (text == null && this.isLazy()) {
            return;
        }
        if (parent.getNodeType() == 1) {
            if (text == null) {
                text = "";
            }
            Attr att = parent.getOwnerDocument().createAttributeNS(this.getNamespace(), this.getLocalName());
            att.setValue(text);
            att.setPrefix(this.getPrefix());
            parent.setAttributeNode(att);
        }
    }

    public int getType() {
        return 1;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isNillable() {
        return false;
    }

    public boolean isRepeating() {
        return false;
    }

    public void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", localName=").append(this.localName);
        if (this.prefix != null) {
            s.append(", prefix=").append(this.prefix);
        }
        if (this.namespace != null) {
            s.append(", xmlns=").append(this.isNamespaceAware() ? this.namespace : "*");
        }
    }
}

