/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.json;

import java.util.List;
import java.util.Map;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.json.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUnmarshallingContext
extends UnmarshallingContext {
    private Object[] valueStack;
    private char[] typeStack;
    private int depth = 0;

    public JsonUnmarshallingContext(int maxDepth) {
        this.valueStack = new Object[maxDepth];
        this.typeStack = new char[maxDepth];
    }

    @Override
    public void setRecordValue(Object value) {
        this.depth = 0;
        this.valueStack[0] = value;
        this.typeStack[0] = 79;
    }

    private Map<String, Object> map() {
        return (Map)this.valueStack[this.depth];
    }

    private List<Object> list() {
        return (List)this.valueStack[this.depth];
    }

    public Object getValue(JsonNode node) {
        List<Object> parent;
        String fieldName = node.getJsonName();
        if (this.typeStack[this.depth] == 'O') {
            Object value = this.map().get(fieldName);
            if (value == null) {
                return this.map().containsKey(fieldName) ? Value.NIL : null;
            }
            return value;
        }
        int index = node.getJsonArrayIndex();
        if (index < 0) {
            index = this.getRelativeFieldIndex();
        }
        if (index < (parent = this.list()).size()) {
            Object value = parent.get(index);
            if (value == null) {
                return Value.NIL;
            }
            return value;
        }
        return null;
    }

    public Object push(JsonNode node, boolean validate) {
        Object value = this.getValue(node);
        if (value == Value.NIL) {
            if (validate && !node.isNillable()) {
                this.addFieldError(node.getName(), null, "nillable", new Object[0]);
                return Value.INVALID;
            }
            return Value.NIL;
        }
        if (value == null) {
            return null;
        }
        if (node.getJsonType() == 'A') {
            if (!(value instanceof List)) {
                if (validate) {
                    this.addFieldError(node.getName(), null, "jsontype", "array");
                    return Value.INVALID;
                }
                return null;
            }
        } else if (node.getJsonType() == 'O') {
            if (!(value instanceof Map)) {
                if (validate) {
                    System.out.println("HERE");
                    this.addFieldError(node.getName(), null, "jsontype", "object");
                    return Value.INVALID;
                }
                return null;
            }
        } else {
            throw new IllegalStateException("Invalid json type: " + node.getJsonType());
        }
        ++this.depth;
        this.valueStack[this.depth] = value;
        this.typeStack[this.depth] = node.getJsonType();
        return value;
    }

    public Object pop() {
        return this.valueStack[this.depth--];
    }
}

