/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.fixedlength;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.beanio.internal.parser.MarshallingContext;

public class FixedLengthMarshallingContext
extends MarshallingContext {
    private char filler = (char)32;
    private int committed = 0;
    private ArrayList<Entry> entries = new ArrayList();

    public void clear() {
        super.clear();
        this.committed = 0;
        this.entries.clear();
    }

    public void setFieldText(int position, String text, boolean commit) {
        int index = this.getAdjustedFieldPosition(position);
        Entry entry = new Entry(index, text);
        this.entries.add(entry);
        if (commit) {
            this.committed = this.entries.size();
        }
    }

    public Object getRecordObject() {
        StringBuilder record = new StringBuilder();
        List<Entry> committedEntries = this.committed < this.entries.size() ? this.entries.subList(0, this.committed) : this.entries;
        Collections.sort(committedEntries);
        int size = 0;
        int offset = -1;
        for (Entry entry : committedEntries) {
            int index = entry.position;
            if (index < 0) {
                if (offset == -1) {
                    offset = size + Math.abs(index);
                    index = size;
                } else {
                    index += offset;
                }
            }
            if (index < size) {
                record.replace(index, index + entry.text.length(), entry.text);
                size = record.length();
                continue;
            }
            while (index > size) {
                record.append(this.filler);
                ++size;
            }
            record.append(entry.text);
            size += entry.text.length();
        }
        return record.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        int position;
        int order;
        String text;

        public Entry(int position, String text) {
            this.position = position;
            this.order = position < 0 ? position + Integer.MAX_VALUE : position;
            this.text = text;
        }

        @Override
        public int compareTo(Entry o) {
            return new Integer(this.order).compareTo(o.order);
        }

        public String toString() {
            return this.order + ":" + this.text;
        }
    }
}

