/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.fixedlength;

import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.fixedlength.FixedLengthMarshallingContext;
import org.beanio.internal.parser.format.fixedlength.FixedLengthUnmarshallingContext;
import org.beanio.internal.parser.format.flat.FlatFieldFormatSupport;

public class FixedLengthFieldFormat
extends FlatFieldFormatSupport
implements FieldFormat {
    private boolean keepPadding;
    private boolean lenientPadding;

    public String extract(UnmarshallingContext context, boolean reportErrors) {
        String text = this.extractFieldText(context, reportErrors);
        if (text == null) {
            return null;
        }
        FieldPadding padding = this.getPadding();
        if (padding.getLength() >= 0 && text.length() != padding.getLength() && !this.lenientPadding) {
            if (reportErrors) {
                context.addFieldError(this.getName(), text, "length", padding.getLength());
            }
            return Value.INVALID;
        }
        if (this.keepPadding) {
            String s;
            if (!padding.isOptional() && (s = padding.unpad(text)).length() == 0) {
                return s;
            }
            return text;
        }
        return padding.unpad(text);
    }

    public String extractFieldText(UnmarshallingContext context, boolean reporting) {
        FixedLengthUnmarshallingContext ctx = (FixedLengthUnmarshallingContext)context;
        return ctx.getFieldText(this.getName(), this.getPosition(), this.getSize(), this.getUntil());
    }

    public void insertFieldText(MarshallingContext context, String fieldText, boolean commit) {
        FixedLengthMarshallingContext ctx = (FixedLengthMarshallingContext)context;
        ctx.setFieldText(this.getPosition(), fieldText, commit);
    }

    public int getSize() {
        return this.getPadding().getLength();
    }

    public void setKeepPadding(boolean keepPadding) {
        this.keepPadding = keepPadding;
    }

    public void setLenientPadding(boolean lenientPadding) {
        this.lenientPadding = lenientPadding;
    }
}

