/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.accessor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.beanio.BeanIOException;
import org.beanio.internal.parser.PropertyAccessor;
import org.beanio.internal.parser.accessor.PropertyAccessorSupport;

public class MethodReflectionAccessor
extends PropertyAccessorSupport
implements PropertyAccessor {
    private PropertyDescriptor descriptor;
    private Method getter;
    private Method setter;

    public MethodReflectionAccessor(PropertyDescriptor descriptor, int constructorArgumentIndex) {
        this.descriptor = descriptor;
        this.setConstructorArgumentIndex(constructorArgumentIndex);
        if (descriptor != null) {
            this.getter = descriptor.getReadMethod();
            this.setter = descriptor.getWriteMethod();
        }
    }

    public Object getValue(Object bean) {
        if (this.getter == null) {
            throw new BeanIOException("There is no readable property named '" + this.descriptor.getName() + "' on bean class '" + bean.getClass().getName() + "'");
        }
        try {
            return this.getter.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new BeanIOException("Failed to invoke method '" + this.getter.getName() + "' on bean class '" + bean.getClass().getName() + "'", ex);
        }
    }

    public void setValue(Object bean, Object value) {
        if (this.setter == null) {
            throw new BeanIOException("There is no writeable property named '" + this.descriptor.getName() + "' on class '" + bean.getClass().getName() + "'");
        }
        try {
            this.setter.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new BeanIOException("Failed to invoke method '" + this.setter.getName() + "' on bean class '" + bean.getClass().getName() + "'", ex);
        }
    }
}

