/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.beanio.BeanReaderException;
import org.beanio.BeanReaderIOException;
import org.beanio.InvalidRecordException;
import org.beanio.InvalidRecordGroupException;
import org.beanio.MalformedRecordException;
import org.beanio.RecordContext;
import org.beanio.UnexpectedRecordException;
import org.beanio.UnidentifiedRecordException;
import org.beanio.internal.parser.ErrorContext;
import org.beanio.internal.parser.MessageFactory;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnmarshallingContext
extends ParsingContext {
    private Locale locale;
    private MessageFactory messageFactory;
    private RecordReader recordReader;
    private boolean eof;
    private boolean processed = true;
    private String componentName;
    private boolean isRecordGroup;
    private int lineNumber = 0;
    private int recordCount = 0;
    private ErrorContext recordContext = new ErrorContext();
    private boolean dirty;
    private List<ErrorContext> recordList = new ArrayList<ErrorContext>();

    @Override
    public final char getMode() {
        return 'U';
    }

    public abstract void setRecordValue(Object var1);

    public Object toRecordValue(String[] array) {
        return null;
    }

    public Object toRecordValue(List<String> list) {
        return null;
    }

    public Object toRecordValue(Node node) {
        return null;
    }

    public void prepare(String componentName, boolean isRecordGroup) {
        if (this.dirty) {
            this.recordContext = new ErrorContext();
            this.dirty = false;
        } else {
            this.recordContext.clear();
        }
        if (this.recordCount > 0) {
            this.recordList.clear();
        }
        this.recordCount = 0;
        this.dirty = false;
        this.componentName = componentName;
        this.isRecordGroup = isRecordGroup;
    }

    public final void recordStarted(String recordName) {
        ++this.recordCount;
        this.recordContext.setRecordName(recordName);
        this.recordContext.setLineNumber(this.getLineNumber());
        this.recordContext.setRecordText(this.getRecordReader().getRecordText());
    }

    public final void recordCompleted() {
        this.processed = true;
        if (this.isRecordGroup) {
            this.recordList.add(this.recordContext);
            this.recordContext = new ErrorContext();
        }
    }

    public final void recordSkipped() {
        this.processed = true;
    }

    public final void validate() throws InvalidRecordException {
        if (this.isRecordGroup) {
            boolean hasErrors = false;
            for (RecordContext recordContext : this.recordList) {
                if (!recordContext.hasErrors()) continue;
                hasErrors = true;
                break;
            }
            if (hasErrors) {
                RecordContext[] rca = new RecordContext[this.recordList.size()];
                this.recordList.toArray(rca);
                throw new InvalidRecordGroupException(rca, "Invalid '" + this.componentName + "' record group at line " + rca[0].getLineNumber(), this.componentName);
            }
        } else if (this.recordContext.hasErrors()) {
            this.dirty = true;
            if (this.lineNumber > 0) {
                throw new InvalidRecordException(this.recordContext, "Invalid '" + this.componentName + "' record at line " + this.lineNumber);
            }
            throw new InvalidRecordException(this.recordContext, "Invalid '" + this.componentName + "' record");
        }
    }

    public final int getRecordCount() {
        return this.recordCount;
    }

    public final RecordContext getRecordContext(int index) throws IndexOutOfBoundsException {
        if (this.isRecordGroup) {
            return this.recordList.get(index);
        }
        if (this.recordCount > 0 && index == 0) {
            this.dirty = true;
            return this.recordContext;
        }
        throw new IndexOutOfBoundsException();
    }

    public final void setFieldText(String fieldName, String text) {
        this.recordContext.setFieldText(fieldName, text, this.isRepeating());
    }

    public final boolean hasFieldErrors() {
        return this.recordContext.hasFieldErrors();
    }

    public final boolean hasRecordErrors() {
        return this.recordContext.hasRecordErrors();
    }

    public String addFieldError(String fieldName, String fieldText, String rule, Object ... params) {
        Object[] messageParams;
        int lineNumber = this.recordContext.getLineNumber();
        String recordName = this.recordContext.getRecordName();
        String recordLabel = this.messageFactory.getRecordLabel(recordName);
        String fieldLabel = this.messageFactory.getFieldLabel(recordName, fieldName);
        if (recordLabel == null) {
            recordLabel = "'" + recordName + "'";
        }
        if (fieldLabel == null) {
            fieldLabel = "'" + fieldName + "'";
        }
        if (params.length == 0) {
            messageParams = new Object[]{lineNumber, recordLabel, fieldLabel, fieldText};
        } else {
            messageParams = new Object[4 + params.length];
            messageParams[0] = lineNumber;
            messageParams[1] = recordLabel;
            messageParams[2] = fieldLabel;
            messageParams[3] = fieldText;
            System.arraycopy(params, 0, messageParams, 4, params.length);
        }
        String pattern = this.messageFactory.getFieldErrorMessage(recordName, fieldName, rule);
        MessageFormat mf = new MessageFormat(pattern, this.locale);
        String message = mf.format(messageParams);
        this.recordContext.addFieldError(fieldName, message);
        return message;
    }

    public final String addRecordError(String rule, Object ... params) {
        return this.addRecordError(this.recordContext, rule, params);
    }

    protected String addRecordError(ErrorContext errorContext, String rule, Object ... params) {
        Object[] messageParams;
        int lineNumber = errorContext.getLineNumber();
        String recordName = errorContext.getRecordName();
        String recordLabel = null;
        if (recordName != null) {
            recordLabel = this.messageFactory.getRecordLabel(recordName);
        }
        if (recordLabel == null) {
            recordLabel = "'" + recordName + "'";
        }
        if (params.length == 0) {
            messageParams = new Object[]{lineNumber, recordLabel, errorContext.getRecordText()};
        } else {
            messageParams = new Object[3 + params.length];
            messageParams[0] = lineNumber;
            messageParams[1] = recordLabel;
            messageParams[2] = errorContext.getRecordText();
            System.arraycopy(params, 0, messageParams, 3, params.length);
        }
        String pattern = this.messageFactory.getRecordErrorMessage(recordName, rule);
        String message = new MessageFormat(pattern, this.locale).format(messageParams);
        errorContext.addRecordError(message);
        return message;
    }

    public BeanReaderException newMalformedRecordException(RecordIOException cause) {
        return new MalformedRecordException(this.recordException(null, "malformed", cause.getMessage()), "Malformed record at line " + this.recordReader.getRecordLineNumber() + ": " + cause.getMessage());
    }

    public BeanReaderException newUnsatisfiedGroupException(String groupName) {
        if (this.isEOF()) {
            return new UnexpectedRecordException(this.recordException(groupName, "unsatisfied", new Object[0]), "End of stream reached, expected record from group '" + groupName + "'");
        }
        return new UnexpectedRecordException(this.recordException(groupName, "unsatisfied", new Object[0]), "Expected record from group '" + groupName + "' at line " + this.recordReader.getRecordLineNumber());
    }

    public BeanReaderException newUnsatisfiedRecordException(String recordName) {
        if (this.isEOF()) {
            return new UnexpectedRecordException(this.recordException(recordName, "unsatisfied", new Object[0]), "End of stream reached, expected record '" + recordName + "'");
        }
        return new UnexpectedRecordException(this.recordException(recordName, "unsatisfied", new Object[0]), "Expected record '" + recordName + "' at line " + this.recordReader.getRecordLineNumber());
    }

    public BeanReaderException recordUnexpectedException(String recordName) {
        return new UnexpectedRecordException(this.recordException(recordName, "unexpected", new Object[0]), "Unexpected record '" + recordName + "' at line " + this.recordReader.getRecordLineNumber());
    }

    public BeanReaderException recordUnidentifiedException() {
        return new UnidentifiedRecordException(this.recordException(null, "unidentified", new Object[0]), "Unidentified record at line " + this.recordReader.getRecordLineNumber());
    }

    protected ErrorContext recordException(String recordName, String rule, Object ... params) {
        this.processed = true;
        ErrorContext ec = new ErrorContext();
        ec.setRecordName(recordName);
        ec.setLineNumber(this.getLineNumber());
        ec.setRecordText(this.recordReader.getRecordText());
        this.addRecordError(ec, rule, params);
        return ec;
    }

    public final void nextRecord() throws BeanReaderException {
        if (!this.processed || this.eof) {
            return;
        }
        super.clear();
        this.processed = false;
        try {
            Object recordValue = this.recordReader.read();
            if (recordValue == null) {
                this.eof = true;
                ++this.lineNumber;
            } else {
                this.setRecordValue(recordValue);
                this.lineNumber = this.recordReader.getRecordLineNumber();
            }
        }
        catch (RecordIOException e) {
            this.lineNumber = this.recordReader.getRecordLineNumber();
            throw this.newMalformedRecordException(e);
        }
        catch (IOException e) {
            throw new BeanReaderIOException("IOException caught reading from input stream", e);
        }
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final boolean isEOF() {
        return this.eof;
    }

    public final RecordReader getRecordReader() {
        return this.recordReader;
    }

    public final void setRecordReader(RecordReader recordReader) {
        this.recordReader = recordReader;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

