/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.Field;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParserComponent;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.DebugUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment
extends ParserComponent {
    private int size;
    private boolean optional;
    private boolean existencePredetermined;
    private boolean identifier;
    private boolean repeating;
    private Property property;
    private ParserLocal<List<Parser>> missing = new ParserLocal<List<Parser>>(){

        @Override
        protected List<Parser> createDefaultValue() {
            return new ArrayList<Parser>();
        }
    };

    @Override
    public void clearValue(ParsingContext context) {
        if (this.property != null) {
            this.property.clearValue(context);
        }
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        if (this.isIdentifier()) {
            for (Component node : this.getChildren()) {
                if (((Parser)((Object)node)).matches(context)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        List<Parser> missing = this.missing.get(context);
        boolean exists = this.isExistencePredetermined();
        for (Component node : this.getChildren()) {
            Parser parser = (Parser)((Object)node);
            if (parser.unmarshal(context)) {
                exists = true;
                continue;
            }
            if (parser.isOptional()) continue;
            missing.add(parser);
        }
        if (exists || !this.optional) {
            if (missing.isEmpty()) {
                if (this.property != null) {
                    this.property.createValue(context);
                }
            } else {
                for (Parser parser : missing) {
                    context.addFieldError(parser.getName(), null, "minOccurs", 1);
                }
            }
        }
        missing.clear();
        return exists;
    }

    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        if (this.optional && !this.repeating && !this.hasContent(context)) {
            return false;
        }
        for (Component node : this.getChildren()) {
            ((Parser)((Object)node)).marshal(context);
        }
        return true;
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        if (this.property != null) {
            return this.property.getValue(context) != Value.MISSING;
        }
        for (Component c : this.getChildren()) {
            if (!((Parser)((Object)c)).hasContent(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(ParsingContext context) {
        if (this.property == null) {
            return null;
        }
        return this.property.getValue(context);
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (this.property != null) {
            this.property.setValue(context, value);
        }
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(boolean identifier) {
        this.identifier = identifier;
    }

    public void registerLocals(Set<ParserLocal<?>> locals) {
        if (this.property != null) {
            ((Component)((Object)this.property)).registerLocals(locals);
        }
        if (locals.add(this.missing)) {
            super.registerLocals(locals);
        }
    }

    public boolean isExistencePredetermined() {
        return this.existencePredetermined;
    }

    public void setExistencePredetermined(boolean existencePredetermined) {
        this.existencePredetermined = existencePredetermined;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", size=").append(this.size == Integer.MAX_VALUE ? "unbounded" : Integer.toString(this.getSize()));
        s.append(", ").append(DebugUtil.formatOption("rid", this.identifier));
        s.append(", ").append(DebugUtil.formatOption("repeating", this.repeating));
        s.append(", ").append(DebugUtil.formatOption("optional", this.isOptional()));
        if (this.property != null) {
            if (this.property instanceof Field) {
                s.append(", property=$").append(this.property.getName());
            } else {
                s.append(", property=").append(this.property);
            }
        }
    }
}

