/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Map;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.RecordAggregation;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordMap
extends RecordAggregation {
    private Property key;

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        boolean result = super.unmarshal(context);
        Object aggregatedValue = this.getSelector().getValue(context);
        if (aggregatedValue != Value.INVALID) {
            Object keyValue = this.key.getValue(context);
            if (!this.lazy || StringUtil.hasValue(keyValue) || StringUtil.hasValue(aggregatedValue)) {
                Object aggregation = this.value.get(context);
                if (aggregation == null || aggregation == Value.MISSING) {
                    aggregation = this.createAggregationType();
                    this.value.set(context, aggregation);
                }
                Map map = (Map)aggregation;
                map.put(keyValue, aggregatedValue);
            }
        }
        this.getParser().clearValue(context);
        return result;
    }

    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        int minOccurs = this.getMinOccurs();
        Map<Object, Object> map = this.getMap(context);
        if (map == null && minOccurs == 0) {
            return false;
        }
        Parser delegate = this.getParser();
        int maxOccurs = this.getMaxOccurs();
        int index = 0;
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (index < maxOccurs) {
                    this.key.setValue(context, entry.getKey());
                    delegate.setValue(context, entry.getValue());
                    delegate.marshal(context);
                    ++index;
                    continue;
                }
                return true;
            }
        }
        if (index < minOccurs) {
            this.key.setValue(context, null);
            delegate.setValue(context, null);
            while (index < minOccurs) {
                delegate.marshal(context);
                ++index;
            }
        }
        return true;
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (value != null && ((Map)value).isEmpty()) {
            value = null;
        }
        super.setValue(context, value);
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        Map<Object, Object> map = this.getMap(context);
        return map != null && map.size() > 0;
    }

    protected Map<Object, Object> getMap(ParsingContext context) {
        return (Map)super.getValue(context);
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public boolean defines(Object value) {
        return value != null && Map.class.isAssignableFrom(value.getClass());
    }

    public Property getKey() {
        return this.key;
    }

    public void setKey(Property key) {
        this.key = key;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        if (this.key != null) {
            s.append(", key=$").append(this.key.getName());
        }
    }
}

