/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Collection;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.RecordAggregation;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordCollection
extends RecordAggregation {
    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        boolean result = super.unmarshal(context);
        Object aggregatedValue = this.getSelector().getValue(context);
        if (aggregatedValue != Value.INVALID && (!this.lazy || StringUtil.hasValue(aggregatedValue))) {
            Object aggregation = this.value.get(context);
            if (aggregation == null || aggregation == Value.MISSING) {
                aggregation = this.createAggregationType();
                this.value.set(context, aggregation);
            }
            Collection collection = (Collection)aggregation;
            collection.add(aggregatedValue);
        }
        this.getParser().clearValue(context);
        return result;
    }

    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        int minOccurs = this.getMinOccurs();
        Collection<Object> collection = this.getCollection(context);
        if (collection == null && minOccurs == 0) {
            return false;
        }
        Parser delegate = this.getParser();
        int maxOccurs = this.getMaxOccurs();
        int index = 0;
        if (collection != null) {
            for (Object value : collection) {
                if (index < maxOccurs) {
                    delegate.setValue(context, value);
                    delegate.marshal(context);
                    ++index;
                    continue;
                }
                return true;
            }
        }
        if (index < minOccurs) {
            delegate.setValue(context, null);
            while (index < minOccurs) {
                delegate.marshal(context);
                ++index;
            }
        }
        return true;
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (value != null && ((Collection)value).isEmpty()) {
            value = null;
        }
        super.setValue(context, value);
    }

    protected Collection<Object> getCollection(ParsingContext context) {
        return (Collection)super.getValue(context);
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        Collection<Object> collection = this.getCollection(context);
        return collection != null && collection.size() > 0;
    }
}

