/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.util.ArrayList;
import org.beanio.internal.parser.Iteration;

public abstract class ParsingContext {
    public static final char UNMARSHALLING = 'U';
    public static final char MARSHALLING = 'M';
    private int fieldOffset = 0;
    private Object[] localHeap;
    private ArrayList<Iteration> iterationStack = new ArrayList();

    protected void clear() {
        this.fieldOffset = 0;
    }

    public abstract char getMode();

    public void pushIteration(Iteration iteration) {
        this.iterationStack.add(iteration);
    }

    public Iteration popIteration() {
        Iteration iter = this.iterationStack.remove(this.iterationStack.size() - 1);
        if (iter.isDynamicIteration()) {
            this.fieldOffset += iter.getIterationSize() * iter.getIterationIndex(this);
        }
        return iter;
    }

    public final int getAdjustedFieldPosition(int position) {
        for (Iteration i : this.iterationStack) {
            position += i.getIterationIndex(this) * i.getIterationSize();
        }
        return position + this.fieldOffset;
    }

    public final int getRelativeFieldIndex() {
        if (this.iterationStack.isEmpty()) {
            return 0;
        }
        return this.iterationStack.get(this.iterationStack.size() - 1).getIterationIndex(this);
    }

    public final boolean isRepeating() {
        return !this.iterationStack.isEmpty();
    }

    public final void createHeap(int size) {
        this.localHeap = new Object[size];
    }

    public final Object getLocal(int index) {
        return this.localHeap[index];
    }

    public final void setLocal(int index, Object obj) {
        this.localHeap[index] = obj;
    }
}

