/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.beanio.BeanWriterException;
import org.beanio.internal.parser.AbortRecordUnmarshalligException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParserComponent;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.DebugUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends ParserComponent
implements Selector {
    private static final String LAST_MATCHED_KEY = "lastMatched";
    private int minOccurs = 0;
    private int maxOccurs = Integer.MAX_VALUE;
    private int order = 1;
    private Property property = null;
    private ParserLocal<Integer> count = new ParserLocal<Integer>(0);
    private ParserLocal<Selector> lastMatched = new ParserLocal();

    public Group() {
        super(5);
    }

    @Override
    public boolean marshal(MarshallingContext context) throws IOException {
        boolean marshalled = false;
        for (Component node : this.getChildren()) {
            marshalled = ((Parser)((Object)node)).marshal(context) || marshalled;
        }
        return marshalled;
    }

    @Override
    public void skip(UnmarshallingContext context) {
        try {
            Selector child = this.lastMatched.get(context);
            child.skip(context);
            while (true) {
                context.nextRecord();
                if (context.isEOF()) {
                    Selector unsatisfied = this.close(context);
                    if (unsatisfied != null) {
                        throw context.newUnsatisfiedRecordException(unsatisfied.getName());
                    }
                    break;
                }
                child = this.matchCurrent(context);
                if (child == null) {
                    this.reset(context);
                    break;
                }
                child.skip(context);
            }
        }
        catch (UnsatisfiedNodeException ex) {
            throw context.newUnsatisfiedRecordException(ex.getNode().getName());
        }
    }

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        try {
            Selector child = this.lastMatched.get(context);
            child.unmarshal(context);
            while (true) {
                context.nextRecord();
                if (context.isEOF()) {
                    Selector unsatisfied = this.close(context);
                    if (unsatisfied == null) break;
                    throw context.newUnsatisfiedRecordException(unsatisfied.getName());
                }
                child = this.matchCurrent(context);
                if (child == null) {
                    this.reset(context);
                    break;
                }
                try {
                    child.unmarshal(context);
                }
                catch (AbortRecordUnmarshalligException abortRecordUnmarshalligException) {}
            }
            if (this.property != null) {
                this.property.createValue(context);
            }
            return true;
        }
        catch (UnsatisfiedNodeException ex) {
            throw context.newUnsatisfiedRecordException(ex.getNode().getName());
        }
    }

    @Override
    public Selector matchAny(UnmarshallingContext context) {
        for (Component n : this.getChildren()) {
            Selector node = (Selector)((Object)n);
            Selector match = node.matchAny(context);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @Override
    public Selector matchNext(UnmarshallingContext context) {
        try {
            return this.internalMatchNext(context);
        }
        catch (UnsatisfiedNodeException ex) {
            throw context.newUnsatisfiedRecordException(ex.getNode().getName());
        }
    }

    @Override
    public Selector matchNext(MarshallingContext context) {
        try {
            if (this.property == null) {
                return this.internalMatchNext(context);
            }
            String componentName = context.getComponentName();
            if (componentName != null && !this.getName().equals(componentName)) {
                return null;
            }
            Object value = context.getBean();
            if (this.property.defines(value)) {
                this.property.setValue(context, value);
                return this;
            }
            return null;
        }
        catch (UnsatisfiedNodeException ex) {
            throw new BeanWriterException("Bean identification failed: expected record type '" + ex.getNode().getName() + "'", ex);
        }
    }

    private Selector internalMatchNext(ParsingContext context) throws UnsatisfiedNodeException {
        Selector match = this.matchCurrent(context);
        if (match == null && this.maxOccurs > 1) {
            match = this.matchAgain(context);
        }
        if (match != null) {
            return this.property != null ? this : match;
        }
        return null;
    }

    private Selector matchCurrent(ParsingContext context) throws UnsatisfiedNodeException {
        Selector match = null;
        Selector lastMatch = this.lastMatched.get(context);
        Selector unsatisfied = null;
        if (lastMatch != null && !lastMatch.isMaxOccursReached(context) && (match = this.matchNext(context, lastMatch)) != null) {
            return match;
        }
        int position = lastMatch == null ? 1 : lastMatch.getOrder();
        for (Component child : this.getChildren()) {
            Selector node = (Selector)((Object)child);
            if (node == lastMatch || node.getOrder() < position || node.isMaxOccursReached(context)) continue;
            if (node.getOrder() > position) {
                if (unsatisfied != null) {
                    if (lastMatch != null) {
                        throw new UnsatisfiedNodeException(unsatisfied);
                    }
                    return null;
                }
                position = node.getOrder();
            }
            if (node.getCount(context) < node.getMinOccurs() && (context.getMode() != 'M' || node.getProperty() != null)) {
                unsatisfied = node;
            }
            if ((match = this.matchNext(context, node)) == null) continue;
            if (lastMatch == null) {
                this.count.set(context, this.count.get(context) + 1);
            } else {
                lastMatch.reset(context);
            }
            this.lastMatched.set(context, node);
            return match;
        }
        if (lastMatch != null && unsatisfied != null) {
            throw new UnsatisfiedNodeException(unsatisfied);
        }
        return null;
    }

    private Selector matchAgain(ParsingContext context) {
        Selector match = null;
        Selector unsatisfied = null;
        int position = 1;
        if (this.lastMatched.get(context) != null) {
            if (this.getCount(context) >= this.getMaxOccurs()) {
                return null;
            }
            position = 1;
            for (Component child : this.getChildren()) {
                Selector node = (Selector)((Object)child);
                if (node.getOrder() > position) {
                    if (unsatisfied != null) {
                        return null;
                    }
                    position = node.getOrder();
                }
                if (node.getMinOccurs() > 0 && (context.getMode() != 'M' || node.getProperty() != null)) {
                    unsatisfied = node;
                }
                if ((match = this.matchNext(context, node)) == null) continue;
                for (Component c : this.getChildren()) {
                    if (c == node) continue;
                    Selector sel = (Selector)((Object)c);
                    sel.setCount(context, 0);
                    sel.reset(context);
                }
                this.count.set(context, this.count.get(context) + 1);
                node.setCount(context, 1);
                this.lastMatched.set(context, node);
                return match;
            }
        }
        return null;
    }

    private Selector matchNext(ParsingContext context, Selector child) {
        switch (context.getMode()) {
            case 'M': {
                return child.matchNext((MarshallingContext)context);
            }
            case 'U': {
                return child.matchNext((UnmarshallingContext)context);
            }
        }
        throw new IllegalStateException("Invalid mode: " + context.getMode());
    }

    @Override
    public void reset(ParsingContext context) {
        this.lastMatched.set(context, null);
        for (Component c : this.getChildren()) {
            Selector node = (Selector)((Object)c);
            node.setCount(context, 0);
            node.reset(context);
        }
    }

    @Override
    public Selector close(ParsingContext context) {
        Selector lastMatch = this.lastMatched.get(context);
        if (lastMatch == null && this.getMinOccurs() == 0) {
            return null;
        }
        int pos = lastMatch == null ? 1 : lastMatch.getOrder();
        Selector unsatisfied = this.findUnsatisfiedChild(context, pos);
        if (unsatisfied != null) {
            return unsatisfied;
        }
        if (this.getCount(context) < this.getMinOccurs()) {
            if (pos > 1) {
                this.reset(context);
                unsatisfied = this.findUnsatisfiedChild(context, 1);
                if (unsatisfied != null) {
                    return unsatisfied;
                }
            }
            return this;
        }
        return null;
    }

    private Selector findUnsatisfiedChild(ParsingContext context, int from) {
        for (Component c : this.getChildren()) {
            Selector unsatisfied;
            Selector node = (Selector)((Object)c);
            if (node.getOrder() < from || (unsatisfied = node.close(context)) == null) continue;
            return unsatisfied;
        }
        return null;
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        return false;
    }

    @Override
    public boolean isMaxOccursReached(ParsingContext context) {
        return this.lastMatched.get(context) == null && this.getCount(context) >= this.getMaxOccurs();
    }

    @Override
    public int getSize() {
        return -1;
    }

    @Override
    public void updateState(ParsingContext context, String namespace, Map<String, Object> state) {
        state.put(this.getKey(namespace, "count"), this.count.get(context));
        String lastMatchedChildName = "";
        Selector lastMatch = this.lastMatched.get(context);
        if (lastMatch != null) {
            lastMatchedChildName = lastMatch.getName();
        }
        state.put(this.getKey(namespace, LAST_MATCHED_KEY), lastMatchedChildName);
        for (Component node : this) {
            ((Selector)((Object)node)).updateState(context, namespace, state);
        }
    }

    @Override
    public void restoreState(ParsingContext context, String namespace, Map<String, Object> state) {
        String key = this.getKey(namespace, "count");
        Integer n = (Integer)state.get(key);
        if (n == null) {
            throw new IllegalStateException("Missing state information for key '" + key + "'");
        }
        this.count.set(context, n);
        key = this.getKey(namespace, LAST_MATCHED_KEY);
        String lastMatchedChildName = (String)state.get(key);
        if (lastMatchedChildName == null) {
            throw new IllegalStateException("Missing state information for key '" + key + "'");
        }
        if (lastMatchedChildName.length() == 0) {
            this.lastMatched.set(context, null);
            lastMatchedChildName = null;
        }
        for (Component child : this.getChildren()) {
            if (lastMatchedChildName != null && lastMatchedChildName.equals(child.getName())) {
                this.lastMatched.set(context, (Selector)((Object)child));
            }
            ((Selector)((Object)child)).restoreState(context, namespace, state);
        }
    }

    protected String getKey(String namespace, String name) {
        return namespace + "." + this.getName() + "." + name;
    }

    @Override
    public boolean isRecordGroup() {
        return true;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getCount(ParsingContext context) {
        return this.count.get(context);
    }

    @Override
    public void setCount(ParsingContext context, int count) {
        this.count.set(context, count);
    }

    @Override
    public void clearValue(ParsingContext context) {
        if (this.property != null) {
            this.property.clearValue(context);
        }
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        this.property.setValue(context, value);
    }

    @Override
    public Object getValue(ParsingContext context) {
        return this.property.getValue(context);
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    @Override
    public boolean isOptional() {
        return this.minOccurs == 0;
    }

    @Override
    public boolean isIdentifier() {
        return false;
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        if (this.property != null) {
            return this.property.getValue(context) != Value.MISSING;
        }
        for (Component c : this.getChildren()) {
            if (!((Parser)((Object)c)).hasContent(context)) continue;
            return true;
        }
        return false;
    }

    public void registerLocals(Set<ParserLocal<?>> locals) {
        if (this.property != null) {
            ((Component)((Object)this.property)).registerLocals(locals);
        }
        if (locals.add(this.lastMatched)) {
            locals.add(this.count);
            super.registerLocals(locals);
        }
    }

    @Override
    protected boolean isSupportedChild(Component child) {
        return child instanceof Selector;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", order=").append(this.order);
        s.append(", occurs=").append(DebugUtil.formatRange(this.minOccurs, this.maxOccurs));
        if (this.property != null) {
            s.append(", property=").append(this.property);
        }
    }

    private static class UnsatisfiedNodeException
    extends Exception {
        private Selector node;

        public UnsatisfiedNodeException(Selector node) {
            this.node = node;
        }

        public Selector getNode() {
            return this.node;
        }
    }
}

