/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.beanio.BeanReaderException;
import org.beanio.BeanWriterException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.ParserComponent;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.PropertyAccessor;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.DebugUtil;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.TypeUtil;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends ParserComponent
implements Property {
    private static final boolean ERROR_IF_NULL_PRIMITIVE = Settings.getInstance().getBoolean("org.beanio.errorIfNullPrimitive");
    private static final boolean USE_DEFAULT_IF_MISSING = Settings.getInstance().getBoolean("org.beanio.useDefaultIfMissing");
    private static final boolean marshalDefault = Settings.getInstance().getBoolean("org.beanio.marshalDefaultEnabled");
    private ParserLocal<Object> value = new ParserLocal<String>(Value.MISSING);
    private boolean bound;
    private boolean identifier;
    private boolean trim;
    private boolean required;
    private boolean lazy;
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private String literal = null;
    private Pattern regex = null;
    private Object defaultValue;
    private Class<?> propertyType;
    private TypeHandler handler;
    private PropertyAccessor accessor;
    private FieldFormat format;

    public Field() {
        super(0);
    }

    @Override
    public boolean hasContent(ParsingContext context) {
        if (this.isBound()) {
            return this.getValue(context) != Value.MISSING;
        }
        return true;
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public boolean isOptional() {
        return this.format.isLazy();
    }

    @Override
    public boolean defines(Object value) {
        if (value == null) {
            return false;
        }
        if (!this.isIdentifier()) {
            return true;
        }
        if (!TypeUtil.isAssignable(this.getPropertyType(), value.getClass())) {
            return false;
        }
        return this.isMatch(this.formatValue(value));
    }

    @Override
    public boolean matches(UnmarshallingContext context) {
        if (this.isIdentifier()) {
            return this.isMatch(this.format.extract(context, false));
        }
        return true;
    }

    protected boolean isMatch(String text) {
        if (text == null) {
            return false;
        }
        if (text == Value.INVALID) {
            return false;
        }
        if (text == Value.NIL) {
            return false;
        }
        if (this.literal != null && !this.literal.equals(text)) {
            return false;
        }
        return this.regex == null || this.regex.matcher(text).matches();
    }

    @Override
    public boolean marshal(MarshallingContext context) {
        String text;
        if (this.literal != null) {
            text = this.literal;
        } else {
            Object value = this.getValue(context);
            if (marshalDefault && value == Value.MISSING) {
                value = this.defaultValue;
                this.setValue(context, this.defaultValue);
            }
            if (value == Value.MISSING) {
                value = null;
                this.setValue(context, null);
            }
            if (this.format.insertValue(context, value)) {
                return true;
            }
            text = this.formatValue(value);
        }
        this.format.insertField(context, text);
        return true;
    }

    public boolean hasNext(UnmarshallingContext context) {
        return this.format.extract(context, false) != null;
    }

    @Override
    public boolean unmarshal(UnmarshallingContext context) {
        String text = this.format.extract(context, true);
        if (text == null) {
            Object value = Value.MISSING;
            if (USE_DEFAULT_IF_MISSING && this.defaultValue != null) {
                value = this.defaultValue;
            }
            this.setValue(context, value);
            return false;
        }
        if (text == Value.INVALID) {
            this.value.set(context, Value.INVALID);
        } else {
            this.value.set(context, this.parseValue(context, text));
        }
        return true;
    }

    protected Object parseValue(UnmarshallingContext context, String fieldText) {
        boolean valid = true;
        String text = fieldText;
        if (text == Value.NIL) {
            if (!this.format.isNillable()) {
                context.addFieldError(this.getName(), null, "nillable", new Object[0]);
                return Value.INVALID;
            }
            if (this.required) {
                context.addFieldError(this.getName(), null, "required", new Object[0]);
                return Value.INVALID;
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            return null;
        }
        if (text == null) {
            if (!this.format.isLazy()) {
                context.addFieldError(this.getName(), null, "minOccurs", 1);
                return Value.INVALID;
            }
        } else {
            if (this.trim) {
                text = text.trim();
            }
            if (this.lazy && text.length() == 0) {
                text = null;
            }
        }
        if (text == null || text.length() == 0) {
            if (this.required) {
                context.addFieldError(this.getName(), fieldText, "required", new Object[0]);
                valid = false;
            } else if (this.defaultValue != null) {
                return this.defaultValue;
            }
        } else {
            if (this.literal != null && !this.literal.equals(text)) {
                context.addFieldError(this.getName(), fieldText, "literal", this.literal);
                valid = false;
            }
            if (text.length() < this.minLength) {
                context.addFieldError(this.getName(), fieldText, "minLength", this.minLength, this.maxLength);
                valid = false;
            }
            if (text.length() > this.maxLength) {
                context.addFieldError(this.getName(), fieldText, "maxLength", this.minLength, this.maxLength);
                valid = false;
            }
            if (this.regex != null && !this.regex.matcher(text).matches()) {
                context.addFieldError(this.getName(), fieldText, "regex", this.regex.pattern());
                valid = false;
            }
        }
        if (!valid) {
            return Value.INVALID;
        }
        try {
            String value;
            String string = value = this.handler == null ? text : this.handler.parse(text);
            if (value == null && ERROR_IF_NULL_PRIMITIVE && this.propertyType != null && this.propertyType.isPrimitive()) {
                context.addFieldError(this.getName(), fieldText, "type", "Primitive property values cannot be null");
                return Value.INVALID;
            }
            return value;
        }
        catch (TypeConversionException ex) {
            context.addFieldError(this.getName(), fieldText, "type", ex.getMessage());
            return Value.INVALID;
        }
        catch (Exception ex) {
            throw new BeanReaderException("Type conversion failed for field '" + this.getName() + "' while parsing text '" + fieldText + "'", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String formatValue(Object value) {
        String text = null;
        if (this.handler != null) {
            try {
                text = this.handler.format(value);
                if (text != TypeHandler.NIL) return text;
                if (!this.format.isNillable()) return null;
                return Value.NIL;
            }
            catch (Exception ex) {
                throw new BeanWriterException("Type conversion failed for field '" + this.getName() + "' while formatting value '" + value + "'", ex);
            }
        }
        if (value == null) return text;
        return value.toString();
    }

    @Override
    public void clearValue(ParsingContext context) {
        this.value.set(context, Value.MISSING);
    }

    @Override
    public Object createValue(ParsingContext context) {
        return this.getValue(context);
    }

    @Override
    public Object getValue(ParsingContext context) {
        return this.value.get(context);
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        this.value.set(context, value == null ? Value.MISSING : value);
    }

    @Override
    protected boolean isSupportedChild(Component child) {
        return false;
    }

    public String getRegex() {
        return this.regex == null ? null : this.regex.pattern();
    }

    public void setRegex(String pattern) throws PatternSyntaxException {
        this.regex = pattern == null ? null : Pattern.compile(pattern);
    }

    protected Pattern getRegexPattern() {
        return this.regex;
    }

    @Override
    public void registerLocals(Set<ParserLocal<? extends Object>> locals) {
        if (locals.add(this.value)) {
            super.registerLocals(locals);
        }
    }

    public void setPropertyType(Class<?> type) {
        this.propertyType = type;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public boolean isIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(boolean recordIdentifier) {
        this.identifier = recordIdentifier;
    }

    public FieldFormat getFormat() {
        return this.format;
    }

    public void setFormat(FieldFormat format) {
        this.format = format;
    }

    public String getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    @Override
    public Class<?> getType() {
        return this.propertyType;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    @Override
    public void setType(Class<?> type) {
        this.propertyType = type;
    }

    @Override
    public PropertyAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void setAccessor(PropertyAccessor accessor) {
        this.accessor = accessor;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public TypeHandler getHandler() {
        return this.handler;
    }

    public void setHandler(TypeHandler handler) {
        this.handler = handler;
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", type=").append(this.propertyType != null ? this.propertyType.getSimpleName() : null);
        s.append(", size=").append(Integer.toString(this.getSize()));
        s.append(", length=").append(DebugUtil.formatRange(this.minLength, this.maxLength));
        s.append(", ").append(DebugUtil.formatOption("bound", this.bound));
        s.append(", ").append(DebugUtil.formatOption("rid", this.identifier));
        s.append(", ").append(DebugUtil.formatOption("required", this.required));
        s.append(", ").append(DebugUtil.formatOption("lazy", this.lazy));
        s.append(", ").append(DebugUtil.formatOption("trim", this.trim));
        if (this.literal != null) {
            s.append(", literal=").append(this.literal);
        }
        if (this.regex != null) {
            s.append(", regex=").append(this.regex.toString());
        }
        if (this.defaultValue != null) {
            s.append(", default=").append(this.defaultValue);
        }
        s.append(", format=").append(this.format);
    }

    @Override
    public int getSize() {
        return this.format.getSize();
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean property) {
        this.bound = property;
    }
}

