/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.IOException;
import java.util.Set;
import org.beanio.internal.parser.AbortRecordUnmarshalligException;
import org.beanio.internal.parser.DelegatingParser;
import org.beanio.internal.parser.Field;
import org.beanio.internal.parser.Iteration;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.Parser;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.PropertyAccessor;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.DebugUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Aggregation
extends DelegatingParser
implements Property,
Iteration {
    private int minOccurs = 0;
    private int maxOccurs = Integer.MAX_VALUE;
    private PropertyAccessor accessor;
    protected boolean lazy;
    protected Field occurs;
    private ParserLocal<Integer> index = new ParserLocal();

    public abstract boolean isProperty();

    protected abstract int length(Object var1);

    @Override
    public final boolean marshal(MarshallingContext context) throws IOException {
        int min = this.minOccurs;
        int max = this.maxOccurs;
        if (this.occurs != null) {
            min = max = ((Number)this.occurs.getValue(context)).intValue();
            this.setIterationIndex(context, -1);
        }
        return this.marshal(context, this.getParser(), min, max);
    }

    protected abstract boolean marshal(MarshallingContext var1, Parser var2, int var3, int var4) throws IOException;

    @Override
    public final boolean unmarshal(UnmarshallingContext context) {
        int min = this.minOccurs;
        int max = this.maxOccurs;
        if (this.occurs != null) {
            int occursVal;
            Object n = this.occurs.getValue(context);
            if (n == Value.INVALID) {
                throw new AbortRecordUnmarshalligException("Invalid occurences");
            }
            if (n == Value.MISSING) {
                n = 0;
            }
            if ((occursVal = ((Number)n).intValue()) < this.minOccurs) {
                context.addFieldError(this.getName(), null, "minOccurs", this.minOccurs, this.maxOccurs);
                if (occursVal == 0) {
                    return true;
                }
            } else if (occursVal > this.maxOccurs) {
                context.addFieldError(this.getName(), null, "maxOccurs", this.minOccurs, this.maxOccurs);
            }
            min = max = occursVal;
            this.setIterationIndex(context, -1);
        }
        return this.unmarshal(context, this.getParser(), min, max);
    }

    protected abstract boolean unmarshal(UnmarshallingContext var1, Parser var2, int var3, int var4);

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (this.occurs != null && !this.occurs.isBound()) {
            this.occurs.setValue(context, this.length(value));
        }
    }

    @Override
    public boolean isOptional() {
        return this.minOccurs == 0;
    }

    @Override
    public boolean isIdentifier() {
        return false;
    }

    @Override
    public void setIdentifier(boolean identifier) {
        if (identifier) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public PropertyAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void setAccessor(PropertyAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public final int getIterationIndex(ParsingContext context) {
        return this.index.get(context);
    }

    protected final void setIterationIndex(ParsingContext context, int index) {
        this.index.set(context, index);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public Field getOccurs() {
        return this.occurs;
    }

    public void setOccurs(Field occurs) {
        this.occurs = occurs;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public boolean isDynamicIteration() {
        return this.occurs != null;
    }

    @Override
    public void registerLocals(Set<ParserLocal<? extends Object>> locals) {
        if (locals.add(this.index)) {
            super.registerLocals(locals);
        }
    }

    @Override
    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        if (this.occurs != null) {
            s.append("occursRef=$").append(this.occurs.getName());
        }
        s.append(", occurs=").append(DebugUtil.formatRange(this.minOccurs, this.maxOccurs));
        s.append(", ").append(DebugUtil.formatOption("lazy", this.lazy));
    }
}

