/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.config.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.beanio.BeanIOConfigurationException;
import org.beanio.BeanIOException;
import org.beanio.internal.config.xml.XmlConfigurationLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlMappingReader {
    private static final String BEANIO_XMLNS = "http://www.beanio.org/2012/03";
    private static final String BEANIO_XSD = "/org/beanio/xsd/2012/03/mapping.xsd";
    private static final EntityResolver defaultEntityResolver = new DefaultEntityResolver();
    private DocumentBuilderFactory factory = this.createDocumentBuilderFactory();

    public Document loadDocument(InputStream in) throws IOException, BeanIOConfigurationException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(this.createEntityResolver());
            final ArrayList errorMessages = new ArrayList();
            builder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    errorMessages.add("Error at line " + exception.getLineNumber() + ": " + exception.getMessage());
                }

                public void error(SAXParseException exception) throws SAXException {
                    errorMessages.add("Error at line " + exception.getLineNumber() + ": " + exception.getMessage());
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            Document document = builder.parse(in);
            if (!errorMessages.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("Invalid mapping file");
                for (String s : errorMessages) {
                    message.append("\n  ==> ");
                    message.append(s);
                }
                throw new BeanIOConfigurationException(message.toString());
            }
            return document;
        }
        catch (SAXException ex) {
            throw new BeanIOConfigurationException("Malformed mapping file", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BeanIOConfigurationException("Failed to load suitable DOM implementation", ex);
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XmlMappingReader.class.getResource(BEANIO_XSD).toExternalForm());
        }
        catch (IllegalArgumentException ex) {
            throw new BeanIOException("Unable to validate using XSD: JAXP provider [" + factory + "] does not support XML Schema.", ex);
        }
        return factory;
    }

    protected EntityResolver createEntityResolver() {
        return defaultEntityResolver;
    }

    private static class DefaultEntityResolver
    implements EntityResolver {
        private DefaultEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (publicId == null && (XmlMappingReader.BEANIO_XMLNS.equals(systemId) || "http://www.beanio.org/2012/03/mapping.xsd".equals(systemId))) {
                return new InputSource(XmlConfigurationLoader.class.getResourceAsStream(XmlMappingReader.BEANIO_XSD));
            }
            return null;
        }
    }
}

