/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.config.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.config.BeanConfig;
import org.beanio.internal.config.BeanIOConfig;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.ConstantConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.config.TypeHandlerConfig;
import org.beanio.internal.config.annotation.AnnotationParser;
import org.beanio.internal.config.xml.XmlMapping;
import org.beanio.internal.config.xml.XmlMappingReader;
import org.beanio.internal.util.IOUtil;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.StringUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMappingParser
implements StringUtil.PropertySource {
    private static final boolean propertySubstitutionEnabled = Boolean.valueOf(Settings.getInstance().getProperty("org.beanio.propertySubstitutionEnabled"));
    private XmlMappingReader reader;
    private XmlMapping mapping;
    private Map<String, XmlMapping> mappings;
    private ClassLoader classLoader;
    private Properties properties;
    private transient boolean annotatedRecord = false;
    private LinkedList<Include> includeStack = new LinkedList();

    public XmlMappingParser(ClassLoader classLoader, XmlMappingReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        this.reader = reader;
        this.classLoader = classLoader;
    }

    public Collection<BeanIOConfig> loadConfiguration(InputStream in, Properties properties) throws IOException, BeanIOConfigurationException {
        this.properties = properties;
        this.mapping = new XmlMapping();
        this.mappings = new HashMap<String, XmlMapping>();
        this.mappings.put("[root]", this.mapping);
        try {
            this.loadMapping(in);
        }
        catch (BeanIOConfigurationException ex) {
            if (this.mapping.getLocation() != null) {
                throw new BeanIOConfigurationException("Invalid mapping file '" + this.mapping.getName() + "': " + ex.getMessage(), ex);
            }
            throw ex;
        }
        ArrayList<BeanIOConfig> configList = new ArrayList<BeanIOConfig>(this.mappings.size());
        for (XmlMapping m : this.mappings.values()) {
            BeanIOConfig config = m.getConfiguration().clone();
            ArrayList<TypeHandlerConfig> handlerList = new ArrayList<TypeHandlerConfig>();
            m.addTypeHandlers(handlerList);
            config.setTypeHandlerList(handlerList);
            configList.add(config);
        }
        return configList;
    }

    protected final XmlMapping push(String name, String location) {
        XmlMapping m = new XmlMapping(name, location, this.mapping);
        this.mappings.put(location, m);
        this.mapping.addImport(m);
        this.mapping = m;
        return this.mapping;
    }

    protected final void pop() {
        this.mapping = this.mapping.getParent();
    }

    protected final XmlMapping getMapping() {
        return this.mapping;
    }

    protected final int getPositionOffset() {
        if (this.includeStack.isEmpty()) {
            return 0;
        }
        return this.includeStack.getFirst().getOffset();
    }

    protected void loadMapping(InputStream in) throws IOException {
        Document document = this.reader.loadDocument(in);
        this.loadMapping(document.getDocumentElement());
    }

    protected void loadMapping(Element element) {
        BeanIOConfig config = this.mapping.getConfiguration();
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if ("import".equals(name)) {
                this.importConfiguration(child);
                continue;
            }
            if ("property".equals(name)) {
                String key = this.getAttribute(child, "name");
                String value = this.getAttribute(child, "value");
                this.mapping.setProperty(key, value);
                continue;
            }
            if ("typeHandler".equals(name)) {
                TypeHandlerConfig handler = this.createHandlerConfig(child);
                if (handler.getName() != null && this.mapping.isDeclaredGlobalTypeHandler(handler.getName())) {
                    throw new BeanIOConfigurationException("Duplicate global type handler named '" + handler.getName() + "'");
                }
                config.addTypeHandler(this.createHandlerConfig(child));
                continue;
            }
            if ("template".equals(name)) {
                this.createTemplate(child);
                continue;
            }
            if (!"stream".equals(name)) continue;
            config.addStream(this.createStreamConfig(child));
        }
    }

    protected final XmlMapping importConfiguration(Element element) {
        XmlMapping xmlMapping;
        String resource;
        URL url = null;
        String name = resource = this.getAttribute(element, "resource");
        if (resource.startsWith("classpath:")) {
            if ("".equals(resource = resource.substring("classpath:".length()).trim())) {
                throw new BeanIOConfigurationException("Invalid import resource");
            }
            url = IOUtil.getResource(this.classLoader, resource);
            if (url == null) {
                throw new BeanIOConfigurationException("Resource '" + name + "' not found in classpath for import");
            }
        } else if (resource.startsWith("file:")) {
            if ("".equals(resource = resource.substring("file:".length()).trim())) {
                throw new BeanIOConfigurationException("Invalid import resource");
            }
            File file = new File(resource);
            if (!file.canRead()) {
                throw new BeanIOConfigurationException("Resource '" + name + "' not found in file system for import");
            }
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            throw new BeanIOConfigurationException("Import resource name must begin with 'classpath:' or 'file:'");
        }
        if (this.mapping.isLoading(url.toString())) {
            throw new BeanIOConfigurationException("Failed to import resource '" + name + "': Circular reference(s) detected");
        }
        String key = url.toString();
        XmlMapping m = this.mappings.get(key);
        if (m != null) {
            this.mapping.addImport(m);
            return m;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(url.openStream());
            this.push(name, key).getConfiguration().setSource(name);
            this.loadMapping(in);
            this.pop();
            xmlMapping = this.mapping;
        }
        catch (IOException ex) {
            try {
                throw new BeanIOConfigurationException("Failed to import mapping file '" + name + "'", ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(in);
        return xmlMapping;
    }

    protected TypeHandlerConfig createHandlerConfig(Element element) {
        TypeHandlerConfig config = new TypeHandlerConfig();
        config.setName(this.getAttribute(element, "name"));
        config.setType(this.getAttribute(element, "type"));
        config.setClassName(this.getAttribute(element, "class"));
        config.setFormat(this.getAttribute(element, "format"));
        config.setProperties(this.createProperties(element));
        return config;
    }

    protected void createTemplate(Element element) {
        String templateName = element.getAttribute("name");
        if (!this.mapping.addTemplate(templateName, element)) {
            throw new BeanIOConfigurationException("Duplicate template named '" + templateName + "'");
        }
    }

    protected BeanConfig createBeanFactory(Element element) {
        BeanConfig config = new BeanConfig();
        config.setClassName(this.getAttribute(element, "class"));
        config.setProperties(this.createProperties(element));
        return config;
    }

    protected Properties createProperties(Element element) {
        Properties props = null;
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element child;
            String name;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !"property".equals(name = (child = (Element)node).getTagName())) continue;
            if (props == null) {
                props = new Properties();
            }
            String propertyName = this.getAttribute(child, "name");
            String propertyValue = this.getAttribute(child, "value");
            if (propertyValue == null) {
                propertyValue = "";
            }
            props.put(propertyName, propertyValue);
        }
        return props;
    }

    protected StreamConfig createStreamConfig(Element element) {
        StreamConfig config = new StreamConfig();
        config.setName(this.getAttribute(element, "name"));
        config.setFormat(this.getAttribute(element, "format"));
        config.setMode(this.getAttribute(element, "mode"));
        config.setResourceBundle(this.getAttribute(element, "resourceBundle"));
        config.setStrict(this.getBooleanAttribute(element, "strict", config.isStrict()));
        config.setIgnoreUnidentifiedRecords(this.getBooleanAttribute(element, "ignoreUnidentifiedRecords", config.isIgnoreUnidentifiedRecords()));
        this.populatePropertyConfigOccurs(config, element);
        config.setXmlName(this.getAttribute(element, "xmlName"));
        config.setXmlNamespace(this.getOptionalAttribute(element, "xmlNamespace"));
        config.setXmlPrefix(this.getOptionalAttribute(element, "xmlPrefix"));
        config.setXmlType(this.getOptionalAttribute(element, "xmlType"));
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if ("typeHandler".equals(name)) {
                config.addHandler(this.createHandlerConfig(child));
                continue;
            }
            if ("parser".equals(name)) {
                config.setParserFactory(this.createBeanFactory(child));
                continue;
            }
            if ("record".equals(name)) {
                config.add(this.createRecordConfig(child));
                continue;
            }
            if (!"group".equals(name)) continue;
            config.add(this.createGroupConfig(child));
        }
        return config;
    }

    protected GroupConfig createGroupConfig(Element element) {
        String type = this.getAttribute(element, "class");
        GroupConfig config = AnnotationParser.createGroupConfig(this.classLoader, type);
        if (config != null) {
            return config;
        }
        config = new GroupConfig();
        config.setType(type);
        this.populatePropertyConfig(config, element);
        config.setOrder(this.getIntegerAttribute(element, "order"));
        config.setKey(this.getAttribute(element, "key"));
        config.setXmlName(this.getAttribute(element, "xmlName"));
        config.setXmlNamespace(this.getOptionalAttribute(element, "xmlNamespace"));
        config.setXmlPrefix(this.getOptionalAttribute(element, "xmlPrefix"));
        config.setXmlType(this.getOptionalAttribute(element, "xmlType"));
        config.setTarget(this.getAttribute(element, "value"));
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String name = child.getTagName();
            if ("record".equals(name)) {
                config.add(this.createRecordConfig(child));
                continue;
            }
            if (!"group".equals(name)) continue;
            config.add(this.createGroupConfig(child));
        }
        return config;
    }

    protected RecordConfig createRecordConfig(Element element) {
        String template;
        Range range;
        String type = this.getAttribute(element, "class");
        RecordConfig segment = AnnotationParser.createRecordConfig(this.classLoader, type);
        if (segment != null) {
            return segment;
        }
        segment = new RecordConfig();
        segment.setType(type);
        this.populatePropertyConfig(segment, element);
        segment.setKey(this.getAttribute(element, "key"));
        segment.setOrder(this.getIntegerAttribute(element, "order"));
        segment.setMinLength(this.getIntegerAttribute(element, "minLength"));
        segment.setMaxLength(this.getUnboundedIntegerAttribute(element, "maxLength", Integer.MAX_VALUE));
        segment.setXmlName(this.getAttribute(element, "xmlName"));
        segment.setXmlNamespace(this.getOptionalAttribute(element, "xmlNamespace"));
        segment.setXmlPrefix(this.getOptionalAttribute(element, "xmlPrefix"));
        segment.setJsonName(this.getAttribute(element, "jsonName"));
        segment.setJsonType(this.getAttribute(element, "jsonType"));
        segment.setLazy(this.getBooleanAttribute(element, "lazy", segment.isLazy()));
        if (this.hasAttribute(element, "value")) {
            segment.setTarget(this.getAttribute(element, "value"));
            if (this.hasAttribute(element, "target")) {
                throw new BeanIOConfigurationException("Only one 'value' or 'target' can be configured");
            }
        } else {
            segment.setTarget(this.getAttribute(element, "target"));
        }
        if ((range = this.getRangeAttribute(element, "ridLength")) != null) {
            segment.setMinMatchLength(range.getMin());
            segment.setMaxMatchLength(range.getMax());
        }
        if ((template = this.getOptionalAttribute(element, "template")) != null) {
            this.includeTemplate(segment, template, 0);
        }
        this.addProperties(segment, element);
        return segment;
    }

    protected void addProperties(ComponentConfig config, Element element) {
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if (this.annotatedRecord && config.getComponentType() == 'R') {
                throw new BeanIOConfigurationException("Annotated classes may not contain child componennts in a mapping file");
            }
            Element child = (Element)node;
            String name = child.getTagName();
            if ("field".equals(name)) {
                config.add(this.createFieldConfig(child));
                continue;
            }
            if ("segment".equals(name)) {
                config.add(this.createSegmentConfig(child));
                continue;
            }
            if ("property".equals(name)) {
                config.add(this.createConstantConfig(child));
                continue;
            }
            if (!"include".equals(name)) continue;
            this.includeTemplate(config, child);
        }
    }

    protected void includeTemplate(ComponentConfig config, Element element) {
        String template = this.getAttribute(element, "template");
        int offset = this.getIntAttribute(element, "offset", 0);
        this.includeTemplate(config, template, offset);
    }

    protected void includeTemplate(ComponentConfig config, String template, int offset) {
        Element element = this.mapping.findTemplate(template);
        if (element == null) {
            throw new BeanIOConfigurationException("Template '" + template + "' not found");
        }
        for (Include include : this.includeStack) {
            if (!template.equals(include.getTemplate())) continue;
            throw new BeanIOConfigurationException("Circular reference detected in template '" + template + "'");
        }
        Include inc = new Include(template, offset += this.getPositionOffset());
        this.includeStack.addFirst(inc);
        this.addProperties(config, element);
        this.includeStack.removeFirst();
    }

    private void populatePropertyConfig(PropertyConfig config, Element element) {
        config.setName(this.getAttribute(element, "name"));
        config.setGetter(this.getAttribute(element, "getter"));
        config.setSetter(this.getAttribute(element, "setter"));
        config.setCollection(this.getAttribute(element, "collection"));
        this.populatePropertyConfigOccurs(config, element);
    }

    private void populatePropertyConfigOccurs(PropertyConfig config, Element element) {
        boolean hasMinMax;
        boolean hasRef = this.hasAttribute(element, "occursRef");
        if (hasRef) {
            config.setOccursRef(this.getAttribute(element, "occursRef"));
        }
        boolean hasOccurs = this.hasAttribute(element, "occurs");
        boolean bl = hasMinMax = this.hasAttribute(element, "minOccurs") || this.hasAttribute(element, "maxOccurs");
        if (hasOccurs) {
            if (hasMinMax) {
                throw new BeanIOConfigurationException("occurs cannot be used with minOccurs or maxOccurs");
            }
            Range range = this.getRangeAttribute(element, "occurs");
            if (range != null) {
                config.setMinOccurs(range.getMin());
                config.setMaxOccurs(range.getMax());
            }
        } else {
            config.setMinOccurs(this.getIntegerAttribute(element, "minOccurs"));
            config.setMaxOccurs(this.getUnboundedIntegerAttribute(element, "maxOccurs", Integer.MAX_VALUE));
        }
    }

    protected SegmentConfig createSegmentConfig(Element element) {
        SegmentConfig config = new SegmentConfig();
        this.populatePropertyConfig(config, element);
        config.setType(this.getAttribute(element, "class"));
        config.setLazy(this.getBooleanAttribute(element, "lazy", config.isLazy()));
        config.setKey(this.getAttribute(element, "key"));
        config.setXmlName(this.getAttribute(element, "xmlName"));
        config.setXmlNamespace(this.getOptionalAttribute(element, "xmlNamespace"));
        config.setXmlPrefix(this.getOptionalAttribute(element, "xmlPrefix"));
        config.setXmlType(this.getOptionalAttribute(element, "xmlType"));
        config.setNillable(this.getBooleanAttribute(element, "nillable", config.isNillable()));
        config.setJsonName(this.getAttribute(element, "jsonName"));
        config.setJsonType(this.getAttribute(element, "jsonType"));
        String template = this.getOptionalAttribute(element, "template");
        if (template != null) {
            this.includeTemplate(config, template, 0);
        }
        this.addProperties(config, element);
        if (this.hasAttribute(element, "value")) {
            config.setTarget(this.getAttribute(element, "value"));
            if (this.hasAttribute(element, "target")) {
                throw new BeanIOConfigurationException("Only one of 'value' or 'target' can be configured");
            }
        } else {
            config.setTarget(this.getAttribute(element, "target"));
        }
        return config;
    }

    protected FieldConfig createFieldConfig(Element element) {
        Integer until;
        FieldConfig config = new FieldConfig();
        this.populatePropertyConfig(config, element);
        Integer position = this.getIntegerAttribute(element, "at");
        if (position == null) {
            position = this.getIntegerAttribute(element, "position");
        } else if (this.getIntegerAttribute(element, "position") != null) {
            throw new BeanIOConfigurationException("Only one of 'position' or 'at' can be configured");
        }
        if (position != null) {
            if (position >= 0) {
                position = position + this.getPositionOffset();
            }
            config.setPosition(position);
        }
        if ((until = this.getIntegerAttribute(element, "until")) != null) {
            config.setUntil(until);
        }
        config.setMinLength(this.getIntegerAttribute(element, "minLength"));
        config.setMaxLength(this.getUnboundedIntegerAttribute(element, "maxLength", -1));
        config.setRegex(this.getAttribute(element, "regex"));
        config.setLiteral(this.getAttribute(element, "literal"));
        config.setTypeHandler(this.getTypeHandler(element, "typeHandler"));
        config.setType(this.getAttribute(element, "type"));
        config.setFormat(this.getAttribute(element, "format"));
        config.setDefault(this.getOptionalAttribute(element, "default"));
        config.setRequired(this.getBooleanAttribute(element, "required", config.isRequired()));
        config.setTrim(this.getBooleanAttribute(element, "trim", config.isTrim()));
        config.setLazy(this.getBooleanAttribute(element, "lazy", config.isLazy()));
        config.setIdentifier(this.getBooleanAttribute(element, "rid", config.isIdentifier()));
        config.setBound(!this.getBooleanAttribute(element, "ignore", false));
        config.setLength(this.getUnboundedIntegerAttribute(element, "length", -1));
        config.setPadding(this.getCharacterAttribute(element, "padding"));
        config.setKeepPadding(this.getBooleanAttribute(element, "keepPadding", config.isKeepPadding()));
        config.setLenientPadding(this.getBooleanAttribute(element, "lenientPadding", config.isLenientPadding()));
        if (this.hasAttribute(element, "justify")) {
            if (this.hasAttribute(element, "align")) {
                throw new BeanIOConfigurationException("Only one of 'align' or 'justify' can be configured");
            }
            config.setJustify(this.getAttribute(element, "justify"));
        } else {
            config.setJustify(this.getAttribute(element, "align"));
        }
        config.setXmlType(this.getAttribute(element, "xmlType"));
        config.setXmlName(this.getAttribute(element, "xmlName"));
        config.setXmlNamespace(this.getOptionalAttribute(element, "xmlNamespace"));
        config.setXmlPrefix(this.getOptionalAttribute(element, "xmlPrefix"));
        config.setNillable(this.getBooleanAttribute(element, "nillable", config.isNillable()));
        config.setJsonName(this.getAttribute(element, "jsonName"));
        config.setJsonType(this.getAttribute(element, "jsonType"));
        return config;
    }

    protected ConstantConfig createConstantConfig(Element element) {
        ConstantConfig config = new ConstantConfig();
        try {
            config.setName(this.getAttribute(element, "name"));
            config.setGetter(this.getAttribute(element, "getter"));
            config.setSetter(this.getAttribute(element, "setter"));
            config.setType(this.getAttribute(element, "type"));
            config.setTypeHandler(this.getTypeHandler(element, "typeHandler"));
            config.setValue(this.getAttribute(element, "format"));
            config.setIdentifier(this.getBooleanAttribute(element, "rid", config.isIdentifier()));
            config.setValue(this.getAttribute(element, "value"));
            return config;
        }
        catch (BeanIOConfigurationException ex) {
            throw new BeanIOConfigurationException("Invalid '" + config.getName() + "' property definition: " + ex.getMessage());
        }
    }

    @Override
    public String getProperty(String key) {
        Properties mappingProperties;
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null && (mappingProperties = this.mapping.getProperties()) != null) {
            value = mappingProperties.getProperty(key);
        }
        return value;
    }

    private String getTypeHandler(Element element, String name) {
        String handler = this.getAttribute(element, name);
        return handler;
    }

    private String doPropertySubstitution(String text) {
        try {
            return propertySubstitutionEnabled ? StringUtil.doPropertySubstitution(text, this) : text;
        }
        catch (IllegalArgumentException ex) {
            throw new BeanIOConfigurationException(ex.getMessage(), ex);
        }
    }

    private String getOptionalAttribute(Element element, String name) {
        Attr att = element.getAttributeNode(name);
        if (att == null) {
            return null;
        }
        return this.doPropertySubstitution(att.getTextContent());
    }

    private boolean hasAttribute(Element element, String name) {
        return element.getAttributeNode(name) != null;
    }

    private String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if ("".equals(value)) {
            value = null;
        }
        return this.doPropertySubstitution(value);
    }

    private int getIntAttribute(Element element, String name, int defaultValue) {
        String text = this.getAttribute(element, name);
        if (text == null) {
            return defaultValue;
        }
        return Integer.parseInt(text);
    }

    private Character getCharacterAttribute(Element element, String name) {
        String text = this.getAttribute(element, name);
        if (text == null || text.length() == 0) {
            return null;
        }
        return Character.valueOf(text.charAt(0));
    }

    private Integer getIntegerAttribute(Element element, String name) {
        String text = this.getAttribute(element, name);
        if (text == null) {
            return null;
        }
        return Integer.parseInt(text);
    }

    private Integer getUnboundedIntegerAttribute(Element element, String name, int unboundedValue) {
        String text = this.getAttribute(element, name);
        if (text == null) {
            return null;
        }
        if ("unbounded".equals(text)) {
            return unboundedValue;
        }
        return Integer.parseInt(text);
    }

    private Boolean getBooleanAttribute(Element element, String name) {
        String text = this.getAttribute(element, name);
        return text == null ? null : Boolean.valueOf("true".equals(text) || "1".equals(text));
    }

    private boolean getBooleanAttribute(Element element, String name, boolean defaultValue) {
        Boolean b = this.getBooleanAttribute(element, name);
        return b == null ? defaultValue : b;
    }

    private Range getRangeAttribute(Element element, String name) {
        String range = this.getAttribute(element, name);
        if (range == null) {
            return null;
        }
        try {
            Integer min = null;
            Integer max = null;
            if (range.endsWith("+")) {
                min = Integer.parseInt(range.substring(0, range.length() - 1));
                max = Integer.MAX_VALUE;
            } else {
                int n = range.indexOf(45);
                if (n < 0) {
                    min = max = Integer.valueOf(Integer.parseInt(range));
                } else {
                    min = Integer.parseInt(range.substring(0, n));
                    max = Integer.parseInt(range.substring(n + 1));
                }
            }
            return new Range(min, max);
        }
        catch (NumberFormatException ex) {
            throw new BeanIOConfigurationException("Invalid " + name + " '" + range + "'", ex);
        }
    }

    private static final class Range {
        private Integer min;
        private Integer max;

        public Range(Integer min, Integer max) {
            this.min = min;
            this.max = max;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }
    }

    private static final class Include {
        private String template;
        private int offset = 0;

        public Include(String template, int offset) {
            this.template = template;
            this.offset = offset;
        }

        public String getTemplate() {
            return this.template;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

