/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.xml;

import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.util.Settings;

public class XmlPreprocessor
extends Preprocessor {
    public XmlPreprocessor(StreamConfig stream) {
        super(stream);
    }

    protected void initializeGroup(GroupConfig group) {
        String type;
        super.initializeGroup(group);
        if (group.getXmlName() == null) {
            group.setXmlName(group.getName());
        }
        if ((type = group.getXmlType()) == null) {
            group.setXmlType("element");
        } else if (!"none".equals(type) && !"element".equals(type)) {
            throw new BeanIOConfigurationException("Invalid xmlType '" + type + "'");
        }
        if (group.getXmlNamespace() == null) {
            ComponentConfig parent = this.getParent();
            if (parent != null) {
                group.setXmlPrefix(parent.getXmlPrefix());
                group.setXmlNamespace(parent.getXmlNamespace());
                group.setXmlNamespaceAware(parent.isXmlNamespaceAware());
            } else {
                group.setXmlPrefix(null);
                group.setXmlNamespace(null);
                group.setXmlNamespaceAware(false);
            }
        } else if ("*".equals(group.getXmlNamespace())) {
            group.setXmlPrefix(null);
            group.setXmlNamespace(null);
            group.setXmlNamespaceAware(false);
        } else if ("".equals(group.getXmlNamespace())) {
            group.setXmlPrefix(null);
            group.setXmlNamespace(null);
            group.setXmlNamespaceAware(true);
        } else {
            group.setXmlNamespaceAware(true);
        }
    }

    protected void initializeSegment(SegmentConfig segment) {
        String type;
        super.initializeSegment(segment);
        if (segment.getXmlName() == null) {
            segment.setXmlName(segment.getName());
        }
        if ((type = segment.getXmlType()) == null) {
            segment.setXmlType("element");
        } else if (!"none".equals(type) && !"element".equals(type)) {
            throw new BeanIOConfigurationException("Invalid xmlType '" + type + "'");
        }
        if (segment.getXmlPrefix() != null && segment.getXmlNamespace() == null) {
            throw new BeanIOConfigurationException("Missing namespace for configured XML prefix");
        }
        if (segment.getXmlNamespace() == null) {
            ComponentConfig parent = this.getParent();
            segment.setXmlPrefix(parent.getXmlPrefix());
            segment.setXmlNamespace(parent.getXmlNamespace());
            segment.setXmlNamespaceAware(parent.isXmlNamespaceAware());
        } else if ("*".equals(segment.getXmlNamespace())) {
            segment.setXmlPrefix(null);
            segment.setXmlNamespace(null);
            segment.setXmlNamespaceAware(false);
        } else if ("".equals(segment.getXmlNamespace())) {
            segment.setXmlPrefix(null);
            segment.setXmlNamespace(null);
            segment.setXmlNamespaceAware(true);
        } else {
            segment.setXmlNamespaceAware(true);
        }
    }

    protected void handleField(FieldConfig field) {
        String type;
        if (field.getXmlName() == null) {
            field.setXmlName(field.getName());
        }
        if ((type = field.getXmlType()) == null) {
            type = Settings.getInstance().getProperty("org.beanio.xml.defaultXmlType");
            field.setXmlType(type);
        }
        if (!("none".equals(type) || "element".equals(type) || "attribute".equals(type) || "text".equals(type))) {
            throw new BeanIOConfigurationException("Invalid xmlType '" + type + "'");
        }
        if (field.isRepeating() && !"element".equals(type)) {
            throw new BeanIOConfigurationException("Repeating fields must have xmlType 'element'");
        }
        if (field.getXmlNamespace() != null && !"element".equals(type) && !"attribute".equals(type)) {
            throw new BeanIOConfigurationException("XML namespace is not applicable for xmlType '" + type + "'");
        }
        if (field.isNillable() && !"element".equals(type)) {
            throw new BeanIOConfigurationException("xmlType '" + type + "' is not nillable");
        }
        if (field.getXmlPrefix() != null && field.getXmlNamespace() == null) {
            throw new BeanIOConfigurationException("Missing namespace for configured XML prefix");
        }
        boolean isAttribute = "attribute".equals(type);
        if (field.getXmlNamespace() == null) {
            ComponentConfig parent = this.getParent();
            if (isAttribute) {
                field.setXmlPrefix(null);
                field.setXmlNamespace(null);
                field.setXmlNamespaceAware(false);
            } else {
                field.setXmlPrefix(parent.getXmlPrefix());
                field.setXmlNamespace(parent.getXmlNamespace());
                field.setXmlNamespaceAware(parent.isXmlNamespaceAware());
            }
        } else if ("*".equals(field.getXmlNamespace())) {
            field.setXmlPrefix(null);
            field.setXmlNamespace(null);
            field.setXmlNamespaceAware(false);
        } else if ("".equals(field.getXmlNamespace())) {
            field.setXmlPrefix(null);
            field.setXmlNamespace(null);
            field.setXmlNamespaceAware(true);
        } else {
            field.setXmlNamespaceAware(true);
        }
        if (isAttribute && field.getMinOccurs() == null) {
            field.setMinOccurs(0);
        }
        super.handleField(field);
    }

    protected void validateRecordIdentifyingCriteria(FieldConfig field) {
        if ("text".equals(field.getXmlType())) {
            super.validateRecordIdentifyingCriteria(field);
        }
    }
}

