/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.json;

import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;

public class JsonPreprocessor
extends Preprocessor {
    public JsonPreprocessor(StreamConfig stream) {
        super(stream);
    }

    protected void initializeRecord(RecordConfig record) throws BeanIOConfigurationException {
        if (record.getJsonName() == null) {
            record.setJsonName(record.getName());
        }
        if (record.getJsonType() == null) {
            record.setJsonType("none");
        } else if (record.getJsonType().endsWith("[]")) {
            throw new BeanIOConfigurationException("Invalid jsonType '" + record.getJsonType() + "', [] not supported");
        }
        super.initializeRecord(record);
    }

    protected void initializeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
        super.initializeSegment(segment);
        if (segment.getJsonName() == null) {
            segment.setJsonName(segment.getName());
        }
        if (segment.getJsonType() == null) {
            if (segment.getType() != null) {
                segment.setJsonType("object");
                segment.setJsonArray(segment.isRepeating());
            } else {
                segment.setJsonType("none");
            }
        } else {
            String type = segment.getJsonType();
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
                segment.setJsonArray(true);
            } else if (segment.isRepeating() && segment.getComponentType() != 'R') {
                throw new BeanIOConfigurationException("Invalid jsonType '" + segment.getJsonType() + "', expected 'object[]'");
            }
            if (!("object".equals(type) || "none".equals(type) || "array".equals(type))) {
                throw new BeanIOConfigurationException("Invalid jsonType '" + segment.getJsonType() + "'");
            }
            segment.setJsonType(type);
        }
    }

    protected void finalizeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
        super.finalizeSegment(segment);
        if ("array".equals(segment.getJsonType())) {
            int n = 0;
            for (PropertyConfig property : segment.getPropertyList()) {
                property.setJsonArrayIndex(n++);
            }
        }
    }

    protected void handleField(FieldConfig field) throws BeanIOConfigurationException {
        super.handleField(field);
        if (field.getJsonName() == null) {
            field.setJsonName(field.getName());
        }
        if (field.getJsonType() != null) {
            String type = field.getJsonType();
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
                field.setJsonArray(true);
            } else if (field.isRepeating()) {
                throw new BeanIOConfigurationException("Invalid jsonType '" + field.getJsonType() + "', expected array");
            }
            if (!("string".equals(type) || "number".equals(type) || "boolean".equals(type))) {
                throw new BeanIOConfigurationException("Invalid jsonType '" + field.getJsonType() + "'");
            }
            field.setJsonType(type);
        } else if (field.isRepeating()) {
            field.setJsonArray(true);
        }
    }
}

