/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.flat;

import java.util.Comparator;
import java.util.IdentityHashMap;
import org.beanio.internal.compiler.ParserFactorySupport;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.compiler.flat.FlatPreprocessor;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.Aggregation;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.Field;
import org.beanio.internal.parser.Record;
import org.beanio.internal.parser.Segment;
import org.beanio.internal.parser.format.flat.FlatFieldFormat;

public abstract class FlatParserFactory
extends ParserFactorySupport {
    protected Preprocessor createPreprocessor(StreamConfig config) {
        return new FlatPreprocessor(config);
    }

    protected void finalizeRecord(RecordConfig config, Record record) {
        super.finalizeRecord(config, record);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeComparator
    implements Comparator<Component> {
        private IdentityHashMap<Component, Integer> cache = new IdentityHashMap();

        private NodeComparator() {
        }

        @Override
        public int compare(Component o1, Component o2) {
            return this.getPosition(o1).compareTo(this.getPosition(o2));
        }

        private Integer getPosition(Component component) {
            Integer p = this.cache.get(component);
            if (p != null) {
                return p;
            }
            if (component instanceof Field) {
                p = ((FlatFieldFormat)((Field)component).getFormat()).getPosition();
            } else if (component instanceof Aggregation) {
                p = this.getPosition((Component)((Aggregation)component).getFirst());
            } else if (component instanceof Segment) {
                int n = Integer.MAX_VALUE;
                for (Component child : component.getChildren()) {
                    n = Math.min(this.getPosition(child), n);
                }
                p = n;
            }
            if (p < 0) {
                p = Integer.MAX_VALUE + p;
            }
            this.cache.put(component, p);
            return p;
        }
    }
}

