/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.fixedlength;

import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.compiler.fixedlength.FixedLengthPreprocessor;
import org.beanio.internal.compiler.flat.FlatParserFactory;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.parser.FieldFormat;
import org.beanio.internal.parser.RecordFormat;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.format.FieldPadding;
import org.beanio.internal.parser.format.fixedlength.FixedLengthFieldFormat;
import org.beanio.internal.parser.format.fixedlength.FixedLengthFieldPadding;
import org.beanio.internal.parser.format.fixedlength.FixedLengthRecordFormat;
import org.beanio.internal.parser.format.fixedlength.FixedLengthStreamFormat;
import org.beanio.stream.RecordParserFactory;
import org.beanio.stream.fixedlength.FixedLengthRecordParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedLengthParserFactory
extends FlatParserFactory {
    @Override
    protected Preprocessor createPreprocessor(StreamConfig config) {
        return new FixedLengthPreprocessor(config);
    }

    @Override
    public StreamFormat createStreamFormat(StreamConfig config) {
        FixedLengthStreamFormat format = new FixedLengthStreamFormat();
        format.setName(config.getName());
        format.setRecordParserFactory(this.createRecordParserFactory(config));
        return format;
    }

    @Override
    public RecordFormat createRecordFormat(RecordConfig config) {
        FixedLengthRecordFormat format = new FixedLengthRecordFormat();
        if (config.getMinLength() != null) {
            format.setMinLength(config.getMinLength());
        }
        if (config.getMaxLength() != null) {
            format.setMaxLength(config.getMaxLength());
        }
        if (config.getMinMatchLength() != null) {
            format.setMinMatchLength(config.getMinMatchLength());
        }
        if (config.getMaxMatchLength() != null) {
            format.setMaxMatchLength(config.getMaxMatchLength());
        }
        return format;
    }

    @Override
    public FieldFormat createFieldFormat(FieldConfig config, Class<?> type) {
        FixedLengthFieldFormat format = new FixedLengthFieldFormat();
        format.setName(config.getName());
        format.setPosition(config.getPosition());
        format.setUntil(config.getUntil() == null ? 0 : config.getUntil());
        format.setLazy(config.getMinOccurs().equals(0));
        format.setKeepPadding(config.isKeepPadding());
        format.setLenientPadding(config.isLenientPadding());
        FixedLengthFieldPadding padding = new FixedLengthFieldPadding();
        padding.setLength(config.getLength());
        padding.setFiller(config.getPadding().charValue());
        padding.setJustify("right".equals(config.getJustify()) ? (char)'R' : 'L');
        padding.setOptional(!config.isRequired());
        padding.setPropertyType(type);
        ((FieldPadding)padding).init();
        format.setPadding(padding);
        return format;
    }

    @Override
    protected RecordParserFactory getDefaultRecordParserFactory() {
        return new FixedLengthRecordParserFactory();
    }
}

