/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler;

import java.util.LinkedList;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.ConstantConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.StreamConfig;

public abstract class ProcessorSupport {
    private LinkedList<ComponentConfig> configStack = new LinkedList();

    protected void process(StreamConfig stream) throws BeanIOConfigurationException {
        try {
            this.handleComponent(stream);
        }
        catch (BeanIOConfigurationException ex) {
            StringBuilder message = new StringBuilder();
            message.append("Invalid ");
            int index = 0;
            for (ComponentConfig node : this.configStack) {
                String type = null;
                switch (node.getComponentType()) {
                    case 'F': {
                        type = "field";
                        break;
                    }
                    case 'S': {
                        type = "segment";
                        break;
                    }
                    case 'R': {
                        type = "record";
                        break;
                    }
                    case 'G': {
                        type = "group";
                        break;
                    }
                    case 'M': {
                        type = "stream";
                        break;
                    }
                    case 'C': {
                        type = "property";
                        break;
                    }
                    case 'W': {
                        type = "wrapper";
                    }
                }
                if (++index > 1) {
                    message.append(", in ");
                }
                message.append(type).append(" '").append(node.getName()).append("'");
            }
            message.append(": ");
            message.append(ex.getMessage());
            throw new BeanIOConfigurationException(message.toString(), ex);
        }
    }

    protected void handleComponent(ComponentConfig component) {
        this.configStack.addFirst(component);
        switch (component.getComponentType()) {
            case 'M': {
                this.initializeStream((StreamConfig)component);
                for (ComponentConfig child : component) {
                    this.handleComponent(child);
                }
                this.finalizeStream((StreamConfig)component);
                break;
            }
            case 'G': {
                this.initializeGroup((GroupConfig)component);
                for (ComponentConfig child : component) {
                    this.handleComponent(child);
                }
                this.finalizeGroup((GroupConfig)component);
                break;
            }
            case 'R': {
                this.initializeRecord((RecordConfig)component);
                for (ComponentConfig child : component) {
                    this.handleComponent(child);
                }
                this.finalizeRecord((RecordConfig)component);
                break;
            }
            case 'S': {
                this.initializeSegment((SegmentConfig)component);
                for (ComponentConfig child : component) {
                    this.handleComponent(child);
                }
                this.finalizeSegment((SegmentConfig)component);
                break;
            }
            case 'F': {
                this.handleField((FieldConfig)component);
                break;
            }
            case 'C': {
                this.handleConstant((ConstantConfig)component);
            }
        }
        this.configStack.removeFirst();
    }

    protected ComponentConfig getParent() {
        if (this.configStack.size() > 1) {
            return this.configStack.get(1);
        }
        return null;
    }

    protected void initializeStream(StreamConfig stream) throws BeanIOConfigurationException {
    }

    protected void finalizeStream(StreamConfig stream) throws BeanIOConfigurationException {
    }

    protected void initializeGroup(GroupConfig group) throws BeanIOConfigurationException {
    }

    protected void finalizeGroup(GroupConfig group) throws BeanIOConfigurationException {
    }

    protected void initializeRecord(RecordConfig record) throws BeanIOConfigurationException {
    }

    protected void finalizeRecord(RecordConfig record) throws BeanIOConfigurationException {
    }

    protected void initializeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
    }

    protected void finalizeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
    }

    protected void handleField(FieldConfig field) throws BeanIOConfigurationException {
    }

    protected void handleConstant(ConstantConfig constant) throws BeanIOConfigurationException {
    }
}

