/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class BaseCasMvcEndpoint
extends AbstractNamedMvcEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCasMvcEndpoint.class);
    private static final Boolean DEFAULT_SENSITIVE_VALUE = Boolean.TRUE;
    protected final CasConfigurationProperties casProperties;
    @Autowired
    protected ApplicationContext applicationContext;

    public BaseCasMvcEndpoint(String name, String path, MonitorProperties.BaseEndpoint endpoint, CasConfigurationProperties casProperties) {
        super(name, path, DEFAULT_SENSITIVE_VALUE.booleanValue());
        this.casProperties = casProperties;
        this.setEndpointSensitivity(endpoint, casProperties);
        this.setEndpointCapability(endpoint, casProperties);
    }

    private void setEndpointSensitivity(MonitorProperties.BaseEndpoint endpoint, CasConfigurationProperties casProperties) {
        String endpointName = endpoint.getClass().getSimpleName();
        if (endpoint.getSensitive() == null) {
            LOGGER.trace("Sensitivity for endpoint [{}] is undefined. Checking defaults...", (Object)endpointName);
            Boolean defaultSensitive = casProperties.getMonitor().getEndpoints().getSensitive();
            if (defaultSensitive != null) {
                boolean s = BooleanUtils.toBoolean((Boolean)defaultSensitive);
                this.setSensitive(s);
                LOGGER.trace("Default sensitivity for endpoint [{}] is set to [{}]", (Object)endpointName, (Object)s);
            } else {
                LOGGER.trace("Default sensitivity for endpoint [{}] is undefined.", (Object)endpointName);
                this.setSensitive(DEFAULT_SENSITIVE_VALUE);
            }
        } else {
            boolean s = BooleanUtils.toBoolean((Boolean)endpoint.getSensitive());
            this.setSensitive(s);
            LOGGER.trace("Explicitly marking endpoint [{}] sensitivity as [{}]", (Object)endpointName, (Object)s);
        }
    }

    protected static boolean isEndpointCapable(MonitorProperties.BaseEndpoint endpoint, CasConfigurationProperties casProperties) {
        String endpointName = endpoint.getClass().getSimpleName();
        if (endpoint.getEnabled() == null) {
            LOGGER.trace("Capability for endpoint [{}] is undefined. Checking defaults...", (Object)endpointName);
            Boolean defaultEnabled = casProperties.getMonitor().getEndpoints().getEnabled();
            if (defaultEnabled != null) {
                boolean s = BooleanUtils.toBoolean((Boolean)defaultEnabled);
                LOGGER.trace("Default capability for endpoint [{}] is set to [{}]", (Object)endpointName, (Object)s);
                return s;
            }
            LOGGER.trace("Default capability for endpoint [{}] is undefined.", (Object)endpointName);
            return false;
        }
        boolean s = BooleanUtils.toBoolean((Boolean)endpoint.getEnabled());
        LOGGER.trace("Explicitly marking endpoint [{}] capability as [{}]", (Object)endpointName, (Object)s);
        return s;
    }

    private void setEndpointCapability(MonitorProperties.BaseEndpoint endpoint, CasConfigurationProperties casProperties) {
        String endpointName = endpoint.getClass().getSimpleName();
        boolean s = BaseCasMvcEndpoint.isEndpointCapable(endpoint, casProperties);
        LOGGER.trace("Finalized capability for endpoint [{}] is [{}].", (Object)endpointName, (Object)s);
        this.setEnabled(s);
    }

    protected void ensureEndpointAccessIsAuthorized(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isEnabled()) {
            LOGGER.warn("Access to endpoint [{}] is not enabled", (Object)this.getName());
            throw new UnuauthorizedEndpointException();
        }
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED, reason="Access Denied")
    private static class UnuauthorizedEndpointException
    extends RuntimeException {
        private static final long serialVersionUID = 3192230382776656678L;

        private UnuauthorizedEndpointException() {
        }
    }
}

