/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceRequiredHandlersServiceTicketValidationAuthorizer
implements ServiceTicketValidationAuthorizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceRequiredHandlersServiceTicketValidationAuthorizer.class);
    private final ServicesManager servicesManager;

    public void authorize(HttpServletRequest request, Service service, Assertion assertion) {
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        if (registeredService.getRequiredHandlers() != null && !registeredService.getRequiredHandlers().isEmpty()) {
            LOGGER.debug("Evaluating service [{}] to ensure required authentication handlers can satisfy assertion", (Object)service);
            Map attributes = assertion.getPrimaryAuthentication().getAttributes();
            if (attributes.containsKey("successfulAuthenticationHandlers")) {
                Set assertedHandlers = CollectionUtils.toCollection(attributes.get("successfulAuthenticationHandlers"));
                boolean matchesAll = registeredService.getRequiredHandlers().stream().allMatch(assertedHandlers::contains);
                if (!matchesAll) {
                    throw new UnauthorizedServiceException("screen.service.error.message", "");
                }
            }
        }
    }

    @Generated
    public RegisteredServiceRequiredHandlersServiceTicketValidationAuthorizer(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

