/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.InetAddressUtils;

public final class TicketIdSanitizationUtils {
    private static final Pattern TICKET_ID_PATTERN = Pattern.compile("(?:(?:TGT|PGTIOU|PGT)-\\d+-)([\\w.-]+)");
    private static final int VISIBLE_TAIL_LENGTH = 10;
    private static final int HOST_NAME_LENGTH = InetAddressUtils.getCasServerHostName().length();

    private TicketIdSanitizationUtils() {
    }

    public static String sanitize(String msg) {
        String modifiedMessage = msg;
        if (StringUtils.isNotBlank((CharSequence)msg) && !Boolean.getBoolean("CAS_TICKET_ID_SANITIZE_SKIP")) {
            Matcher matcher = TICKET_ID_PATTERN.matcher(msg);
            while (matcher.find()) {
                String match = matcher.group();
                String group = matcher.group(1);
                int replaceLength = group.length() - 10 - (HOST_NAME_LENGTH + 1);
                if (replaceLength <= 0) {
                    replaceLength = group.length();
                }
                String newId = match.replace(group.substring(0, replaceLength), StringUtils.repeat((String)"*", (int)replaceLength));
                modifiedMessage = modifiedMessage.replaceAll(match, newId);
            }
        }
        return modifiedMessage;
    }
}

