/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apereo.cas.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtils.class);

    private SerializationUtils() {
    }

    public static byte[] serialize(Serializable object) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        SerializationUtils.serialize(object, outBytes);
        return outBytes.toByteArray();
    }

    public static void serialize(Serializable object, OutputStream outputStream) {
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
            out.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T deserialize(byte[] inBytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inBytes);
        return SerializationUtils.deserialize(inputStream);
    }

    public static <T> T deserialize(InputStream inputStream) {
        ObjectInputStream in = null;
        try {
            Object obj;
            in = new ObjectInputStream(inputStream);
            Object object = obj = in.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to serialize", (Throwable)e);
                }
            }
        }
    }

    public static byte[] serializeAndEncodeObject(CipherExecutor cipher, Serializable object) {
        byte[] outBytes = SerializationUtils.serialize(object);
        return (byte[])cipher.encode((Object)outBytes);
    }

    public static <T> T decodeAndDeserializeObject(byte[] object, CipherExecutor cipher, Class<? extends Serializable> type) {
        try {
            byte[] decoded = (byte[])cipher.decode((Object)object);
            return SerializationUtils.deserializeAndCheckObject(decoded, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T deserializeAndCheckObject(byte[] object, Class<? extends Serializable> type) {
        T result = SerializationUtils.deserialize(object);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Decoded object is of type " + result.getClass() + " when we were expecting " + type);
        }
        return result;
    }
}

