/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJacksonBackedStringSerializer<T>
implements StringSerializer<T> {
    private static final long serialVersionUID = -8415599777321259365L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJacksonBackedStringSerializer.class);
    private final PrettyPrinter prettyPrinter;
    private final ObjectMapper objectMapper;

    public AbstractJacksonBackedStringSerializer() {
        this((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public AbstractJacksonBackedStringSerializer(PrettyPrinter prettyPrinter) {
        this.objectMapper = this.initializeObjectMapper();
        this.prettyPrinter = prettyPrinter;
    }

    public AbstractJacksonBackedStringSerializer(ObjectMapper objectMapper, PrettyPrinter prettyPrinter) {
        this.objectMapper = objectMapper;
        this.prettyPrinter = prettyPrinter;
    }

    private boolean isJsonFormat() {
        return !(this.objectMapper.getFactory() instanceof YAMLFactory);
    }

    @Override
    public T from(String json) {
        try {
            String jsonString = this.isJsonFormat() ? JsonValue.readHjson((String)json).toString() : json;
            return this.readObjectFromJson(jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T from(File json) {
        try {
            String jsonString = this.isJsonFormat() ? JsonValue.readHjson((String)FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8)).toString() : FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8);
            return this.readObjectFromJson(jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T from(Reader json) {
        try {
            String jsonString = this.isJsonFormat() ? JsonValue.readHjson((Reader)json).toString() : IOUtils.readLines((Reader)json).stream().collect(Collectors.joining());
            return this.readObjectFromJson(jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T from(Writer writer) {
        return this.from(writer.toString());
    }

    @Override
    public T from(InputStream json) {
        try {
            String jsonString = this.readJsonFrom(json);
            return this.readObjectFromJson(jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String readJsonFrom(InputStream json) throws IOException {
        return this.isJsonFormat() ? JsonValue.readHjson((String)IOUtils.toString((InputStream)json, (Charset)StandardCharsets.UTF_8)).toString() : IOUtils.readLines((InputStream)json, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
    }

    @Override
    public void to(OutputStream out, T object) {
        try (StringWriter writer = new StringWriter();){
            this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
            String hjsonString = this.isJsonFormat() ? JsonValue.readHjson((String)writer.toString()).toString(Stringify.HJSON) : writer.toString();
            IOUtils.write((String)hjsonString, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void to(Writer out, T object) {
        try (StringWriter writer = new StringWriter();){
            this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
            if (this.isJsonFormat()) {
                Stringify opt = this.prettyPrinter instanceof MinimalPrettyPrinter ? Stringify.PLAIN : Stringify.FORMATTED;
                JsonValue.readHjson((String)writer.toString()).writeTo(out, opt);
            } else {
                IOUtils.write((String)writer.toString(), (Writer)out);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void to(File out, T object) {
        block39: {
            try (StringWriter writer = new StringWriter();){
                this.objectMapper.writer(this.prettyPrinter).writeValue((Writer)writer, object);
                if (this.isJsonFormat()) {
                    try (FileWriter fileWriter = new FileWriter(out);
                         BufferedWriter buffer = new BufferedWriter(fileWriter);){
                        Stringify opt = this.prettyPrinter instanceof MinimalPrettyPrinter ? Stringify.PLAIN : Stringify.FORMATTED;
                        JsonValue.readHjson((String)writer.toString()).writeTo((Writer)buffer, opt);
                        buffer.flush();
                        fileWriter.flush();
                        break block39;
                    }
                }
                FileUtils.write((File)out, (CharSequence)writer.toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper(this.getJsonFactory());
        this.configureObjectMapper(mapper);
        return mapper;
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        mapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC);
        if (this.isDefaultTypingEnabled()) {
            mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
        mapper.findAndRegisterModules();
    }

    protected boolean isDefaultTypingEnabled() {
        return true;
    }

    protected JsonFactory getJsonFactory() {
        return null;
    }

    protected abstract Class<T> getTypeToSerialize();

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected T readObjectFromJson(String jsonString) {
        try {
            return (T)this.objectMapper.readValue(jsonString, this.getTypeToSerialize());
        }
        catch (Exception e) {
            LOGGER.error("Cannot read/parse JSON [{}] to deserialize into type [{}]. This may be caused in the absence of a configuration/support module that knows how to interpret the JSON fragment, specially if the fragment describes a CAS registered service definition. Internal parsing error is [{}]", new Object[]{DigestUtils.abbreviate(jsonString), this.getTypeToSerialize(), e.getMessage()});
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

