/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.io.SmsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class CommunicationsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommunicationsManager.class);
    @Autowired(required=false)
    @Qualifier(value="smsSender")
    private SmsSender smsSender;
    @Autowired(required=false)
    @Qualifier(value="mailSender")
    private JavaMailSender mailSender;

    public boolean isMailSenderDefined() {
        return this.mailSender != null;
    }

    public boolean isSmsSenderDefined() {
        return this.smsSender != null;
    }

    public boolean email(Principal principal, String attribute, String text, String from, String subject, String cc, String bcc) {
        if (StringUtils.isNotBlank((CharSequence)attribute) && principal.getAttributes().containsKey(attribute) && this.isMailSenderDefined()) {
            String to = CollectionUtils.toCollection(principal.getAttributes().get(attribute)).iterator().next().toString();
            return this.email(text, from, subject, to, cc, bcc);
        }
        return false;
    }

    public boolean email(String text, String from, String subject, String to) {
        return this.email(text, from, subject, to, null, null);
    }

    public boolean email(String text, String from, String subject, String to, String cc, String bcc) {
        try {
            if (!this.isMailSenderDefined() || StringUtils.isBlank((CharSequence)text) || StringUtils.isBlank((CharSequence)from) || StringUtils.isBlank((CharSequence)subject) || StringUtils.isBlank((CharSequence)to)) {
                LOGGER.warn("Could not send email to [{}] because either no address/subject/text is found or email settings are not configured.", (Object)to);
                return false;
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message);
            helper.setTo(to);
            helper.setText(text);
            helper.setSubject(subject);
            helper.setFrom(from);
            helper.setPriority(1);
            if (StringUtils.isNotBlank((CharSequence)cc)) {
                helper.setCc(cc);
            }
            if (StringUtils.isNotBlank((CharSequence)bcc)) {
                helper.setBcc(bcc);
            }
            this.mailSender.send(message);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public boolean sms(Principal principal, String attribute, String text, String from) {
        if (StringUtils.isNotBlank((CharSequence)attribute) && principal.getAttributes().containsKey(attribute) && this.isSmsSenderDefined()) {
            String to = CollectionUtils.toCollection(principal.getAttributes().get(attribute)).iterator().next().toString();
            return this.sms(from, to, text);
        }
        return false;
    }

    public boolean sms(String from, String to, String text) {
        if (!this.isSmsSenderDefined() || StringUtils.isBlank((CharSequence)text) || StringUtils.isBlank((CharSequence)from)) {
            LOGGER.warn("Could not send email to [{}] because either no address/subject/text is found or email settings are not configured.", (Object)to);
            return false;
        }
        return this.smsSender.send(from, to, text);
    }
}

