/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.io.Serializable;
import java.net.URL;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessage
implements Serializable {
    private static final long serialVersionUID = 2015460875654586133L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessage.class);
    private static final boolean DEFAULT_ASYNCHRONOUS_CALLBACKS_ENABLED = true;
    private final URL url;
    private final String message;
    private int responseCode;
    private final boolean asynchronous;
    private String contentType = "application/x-www-form-urlencoded";

    public HttpMessage(URL url, String message) {
        this(url, message, true);
    }

    public HttpMessage(URL url, String message, boolean async) {
        this.url = url;
        this.message = message;
        this.asynchronous = async;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMessage() {
        return this.formatOutputMessageInternal(this.message);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    protected String formatOutputMessageInternal(String message) {
        try {
            return EncodingUtils.urlEncode(message);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to encode URL", (Throwable)e);
            return message;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("message", (Object)this.message).append("asynchronous", this.asynchronous).append("contentType", (Object)this.contentType).append("responseCode", this.responseCode).toString();
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }
}

