/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.crypto;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public class PrivateKeyFactoryBean
extends AbstractFactoryBean<PrivateKey> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyFactoryBean.class);
    private Resource location;
    private String algorithm;

    protected PrivateKey createInstance() throws Exception {
        PrivateKey key = this.readPemPrivateKey();
        if (key == null) {
            LOGGER.debug("Key [{}] is not in PEM format. Trying next...", (Object)this.location);
            key = this.readDERPrivateKey();
        }
        return key;
    }

    /*
     * Exception decompiling
     */
    private PrivateKey readPemPrivateKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKey readDERPrivateKey() {
        LOGGER.debug("Attempting to read key as DER [{}]", (Object)this.location);
        try (InputStream privKey = this.location.getInputStream();){
            byte[] bytes = new byte[(int)this.location.contentLength()];
            privKey.read(bytes);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            PrivateKey privateKey = factory.generatePrivate(privSpec);
            return privateKey;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to read key", (Throwable)e);
            return null;
        }
    }

    public Class getObjectType() {
        return PrivateKey.class;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Resource getLocation() {
        return this.location;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

