/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.cipher.AbstractCipherExecutor;
import org.apereo.cas.util.crypto.PublicKeyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public abstract class BaseStringCipherExecutor
extends AbstractCipherExecutor<Serializable, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStringCipherExecutor.class);
    private static final int ENCRYPTION_KEY_SIZE = 256;
    private static final int SIGNING_KEY_SIZE = 512;
    private String encryptionAlgorithm = "dir";
    private String contentEncryptionAlgorithmIdentifier;
    private Key secretKeyEncryptionKey;
    private boolean encryptionEnabled = true;

    private BaseStringCipherExecutor() {
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, boolean encryptionEnabled) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256", encryptionEnabled);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String alg) {
        this(secretKeyEncryption, secretKeySigning, alg, true);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256", true);
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier, boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
        if (this.encryptionEnabled) {
            this.configureEncryptionParameters(secretKeyEncryption, contentEncryptionAlgorithmIdentifier);
        } else {
            LOGGER.warn("Encryption is not enabled for [{}]. The cipher [{}] will only produce signed objects", (Object)this.getName(), (Object)this.getClass().getSimpleName());
        }
        this.configureSigningParameters(secretKeySigning);
    }

    private void configureSigningParameters(String secretKeySigning) {
        String signingKeyToUse = secretKeySigning;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            LOGGER.warn("Secret key for signing is not defined for [{}]. CAS will attempt to auto-generate the signing key", (Object)this.getName());
            signingKeyToUse = EncodingUtils.generateJsonWebKey(512);
            LOGGER.warn("Generated signing key [{}] of size [{}] for [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{signingKeyToUse, 512, this.getName(), this.getSigningKeySetting()});
        } else {
            LOGGER.debug("Located signing key to use for [{}]", (Object)this.getName());
        }
        this.setSigningKey(signingKeyToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEncryptionParameters(String secretKeyEncryption, String contentEncryptionAlgorithmIdentifier) {
        String secretKeyToUse = secretKeyEncryption;
        if (StringUtils.isBlank((CharSequence)secretKeyToUse)) {
            LOGGER.warn("Secret key for encryption is not defined for [{}]; CAS will attempt to auto-generate the encryption key", (Object)this.getName());
            secretKeyToUse = EncodingUtils.generateJsonWebKey(256);
            LOGGER.warn("Generated encryption key [{}] of size [{}] for [{}]. The generated key MUST be added to CAS settings under setting [{}].", new Object[]{secretKeyToUse, 256, this.getName(), this.getEncryptionKeySetting()});
        } else {
            LOGGER.debug("Located encryption key to use for [{}]", (Object)this.getName());
        }
        try {
            if (ResourceUtils.isFile(secretKeyToUse) && ResourceUtils.doesResourceExist(secretKeyToUse)) {
                AbstractResource resource = ResourceUtils.getResourceFrom(secretKeyToUse);
                LOGGER.debug("Located encryption key resource [{}]. Attempting to extract public key...", (Object)resource);
                PublicKeyFactoryBean factory = new PublicKeyFactoryBean();
                factory.setAlgorithm("RSA");
                factory.setLocation((Resource)resource);
                factory.setSingleton(false);
                this.secretKeyEncryptionKey = (Key)factory.getObject();
                this.encryptionAlgorithm = "RSA-OAEP-256";
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.secretKeyEncryptionKey == null) {
                LOGGER.debug("Creating encryption key instance based on provided secret key");
                this.secretKeyEncryptionKey = EncodingUtils.generateJsonWebKey(secretKeyToUse);
            }
            this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
            LOGGER.debug("Initialized cipher encryption sequence via content encryption [{}] and algorithm [{}]", (Object)this.contentEncryptionAlgorithmIdentifier, (Object)this.encryptionAlgorithm);
        }
    }

    public String encode(Serializable value) {
        String encoded = this.encryptionEnabled ? EncodingUtils.encryptValueAsJwt(this.secretKeyEncryptionKey, value, this.encryptionAlgorithm, this.contentEncryptionAlgorithmIdentifier) : value.toString();
        return new String(this.sign(encoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public String decode(Serializable value) {
        try {
            byte[] encoded = this.verifySignature(value.toString().getBytes(StandardCharsets.UTF_8));
            if (encoded != null && encoded.length > 0) {
                String encodedObj = new String(encoded, StandardCharsets.UTF_8);
                return this.encryptionEnabled ? EncodingUtils.decryptJwtValue(this.secretKeyEncryptionKey, encodedObj) : encodedObj;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected abstract String getEncryptionKeySetting();

    protected abstract String getSigningKeySetting();
}

