/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.jose4j.keys.AesKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public abstract class AbstractCipherExecutor<T, R>
implements CipherExecutor<T, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCipherExecutor.class);
    private Key signingKey;

    protected AbstractCipherExecutor() {
    }

    public AbstractCipherExecutor(String signingSecretKey) {
        this.setSigningKey(signingSecretKey);
    }

    protected byte[] sign(byte[] value) {
        return EncodingUtils.signJwsHMACSha512(this.signingKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSigningKey(String signingSecretKey) {
        try {
            if (ResourceUtils.isFile(signingSecretKey) && ResourceUtils.doesResourceExist(signingSecretKey)) {
                AbstractResource resource = ResourceUtils.getResourceFrom(signingSecretKey);
                LOGGER.debug("Located signing key resource [{}]. Attempting to extract private key...", (Object)resource);
                PrivateKeyFactoryBean factory = new PrivateKeyFactoryBean();
                factory.setAlgorithm("RSA");
                factory.setLocation((Resource)resource);
                factory.setSingleton(false);
                this.signingKey = (Key)factory.getObject();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.signingKey == null) {
                this.signingKey = new AesKey(signingSecretKey.getBytes(StandardCharsets.UTF_8));
                LOGGER.debug("Created signing key instance [{}] based on provided secret key", (Object)this.signingKey.getClass().getSimpleName());
            }
        }
    }

    protected byte[] verifySignature(byte[] value) {
        return EncodingUtils.verifyJwsSignature(this.signingKey, value);
    }

    public boolean isEnabled() {
        return this.signingKey != null;
    }
}

