/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.github.lalyos.jfiglet.FigletFont;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class AsciiArtUtils {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_CYAN = "\u001b[36m";

    private AsciiArtUtils() {
    }

    public static void printAsciiArt(PrintStream out, String asciiArt) {
        AsciiArtUtils.printAsciiArt(out, asciiArt, null);
    }

    public static void printAsciiArt(PrintStream out, String asciiArt, String additional) {
        try {
            out.println(ANSI_CYAN);
            if (StringUtils.isNotBlank((CharSequence)additional)) {
                out.println(FigletFont.convertOneLine((String)asciiArt));
                out.println(additional);
            } else {
                out.print(FigletFont.convertOneLine((String)asciiArt));
            }
            out.println(ANSI_RESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void printAsciiArtWarning(Logger out, String asciiArt, String additional) {
        try {
            out.warn(ANSI_CYAN);
            out.warn("\n\n".concat(FigletFont.convertOneLine((String)asciiArt)).concat(additional));
            out.warn(ANSI_RESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void printAsciiArtInfo(Logger out, String asciiArt, String additional) {
        try {
            out.info(ANSI_CYAN);
            out.info("\n\n".concat(FigletFont.convertOneLine((String)asciiArt)).concat(additional));
            out.info(ANSI_RESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

