/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.support.ConfigurableConversionService;

public class CasConfigurationEmbeddedValueResolver
extends EmbeddedValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationEmbeddedValueResolver.class);
    private final ConfigurableApplicationContext applicationContext;

    public CasConfigurationEmbeddedValueResolver(ApplicationContext applicationContext) {
        super((ConfigurableBeanFactory)((ConfigurableApplicationContext)applicationContext).getBeanFactory());
        this.applicationContext = (ConfigurableApplicationContext)ConfigurableApplicationContext.class.cast(applicationContext);
    }

    public String resolveStringValue(String strVal) {
        String originalValue = super.resolveStringValue(strVal);
        String value = this.convertValueToDurationIfPossible(originalValue);
        if (value != null) {
            return value;
        }
        return originalValue;
    }

    private String convertValueToDurationIfPossible(String value) {
        try {
            ConfigurableConversionService service = this.applicationContext.getEnvironment().getConversionService();
            Duration dur = (Duration)service.convert((Object)value, Duration.class);
            if (dur != null) {
                return String.valueOf(dur.toMillis());
            }
        }
        catch (ConversionFailedException e) {
            LOGGER.trace(e.getMessage());
        }
        return null;
    }
}

