/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ThrottledUseAndTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottledUseAndTimeoutExpirationPolicy.class);
    private static final long serialVersionUID = 205979491183779408L;
    private long timeToKillInSeconds;
    private long timeInBetweenUsesInSeconds;

    @JsonCreator
    public ThrottledUseAndTimeoutExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds, @JsonProperty(value="timeToIdle") long timeInBetweenUsesInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
        this.timeInBetweenUsesInSeconds = timeInBetweenUsesInSeconds;
    }

    @Override
    public boolean isExpired(TicketState ticketState) {
        LOGGER.trace("Checking validity of ticket [{}]", (Object)ticketState);
        ZonedDateTime lastTimeUsed = ticketState.getLastTimeUsed();
        ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.trace("Current time is [{}]. Ticket last used time is [{}]", (Object)currentTime, (Object)lastTimeUsed);
        long currentTimeSeconds = currentTime.toEpochSecond();
        long lastTimeUsedInSeconds = lastTimeUsed.toEpochSecond();
        long margin = currentTimeSeconds - lastTimeUsedInSeconds;
        LOGGER.trace("Current time in seconds is [{}]. Ticket last used time in seconds is [{}]", (Object)currentTimeSeconds, (Object)lastTimeUsedInSeconds);
        if (ticketState.getCountOfUses() == 0 && margin < this.timeToKillInSeconds) {
            LOGGER.debug("Valid [{}]: Usage count is zero and number of seconds since ticket usage time [{}] is less than [{}]", new Object[]{ticketState, margin, this.timeToKillInSeconds});
            return super.isExpired(ticketState);
        }
        if (margin >= this.timeToKillInSeconds) {
            LOGGER.debug("Expired [{}]: number of seconds since ticket usage time [{}] is greater than or equal to [{}]", new Object[]{ticketState, margin, this.timeToKillInSeconds});
            return true;
        }
        if (margin > 0L && margin <= this.timeInBetweenUsesInSeconds) {
            LOGGER.warn("Expired [{}]: number of seconds since ticket usage time [{}] is less than or equal to time in between uses in seconds [{}]", new Object[]{ticketState, margin, this.timeInBetweenUsesInSeconds});
            return true;
        }
        return super.isExpired(ticketState);
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeInBetweenUsesInSeconds;
    }

    @Generated
    public void setTimeToKillInSeconds(long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    @Generated
    public void setTimeInBetweenUsesInSeconds(long timeInBetweenUsesInSeconds) {
        this.timeInBetweenUsesInSeconds = timeInBetweenUsesInSeconds;
    }

    @Generated
    public ThrottledUseAndTimeoutExpirationPolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrottledUseAndTimeoutExpirationPolicy)) {
            return false;
        }
        ThrottledUseAndTimeoutExpirationPolicy other = (ThrottledUseAndTimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.timeToKillInSeconds != other.timeToKillInSeconds) {
            return false;
        }
        return this.timeInBetweenUsesInSeconds == other.timeInBetweenUsesInSeconds;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThrottledUseAndTimeoutExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        long $timeInBetweenUsesInSeconds = this.timeInBetweenUsesInSeconds;
        result = result * 59 + (int)($timeInBetweenUsesInSeconds >>> 32 ^ $timeInBetweenUsesInSeconds);
        return result;
    }
}

