/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class MultiTimeUseOrTimeoutExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTimeUseOrTimeoutExpirationPolicy.class);
    private static final long serialVersionUID = -5704993954986738308L;
    @JsonProperty(value="timeToLive")
    private long timeToKillInSeconds;
    @JsonProperty(value="numberOfUses")
    private int numberOfUses;

    @JsonCreator
    public MultiTimeUseOrTimeoutExpirationPolicy(@JsonProperty(value="numberOfUses") int numberOfUses, @JsonProperty(value="timeToLive") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
        this.numberOfUses = numberOfUses;
        Assert.isTrue((this.numberOfUses > 0 ? 1 : 0) != 0, (String)"numberOfUses must be greater than 0.");
        Assert.isTrue((this.timeToKillInSeconds > 0L ? 1 : 0) != 0, (String)"timeToKillInSeconds must be greater than 0.");
    }

    @Override
    public boolean isExpired(TicketState ticketState) {
        ZonedDateTime lastTimeUsed;
        ZonedDateTime expirationTime;
        if (ticketState == null) {
            LOGGER.debug("Ticket state is null for [{}]. Ticket has expired.", (Object)this.getClass().getSimpleName());
            return true;
        }
        long countUses = ticketState.getCountOfUses();
        if (countUses >= (long)this.numberOfUses) {
            LOGGER.debug("Ticket usage count [{}] is greater than or equal to [{}]. Ticket has expired", (Object)countUses, (Object)this.numberOfUses);
            return true;
        }
        ZonedDateTime systemTime = this.getCurrentSystemTime();
        if (systemTime.isAfter(expirationTime = (lastTimeUsed = ticketState.getLastTimeUsed()).plus(this.timeToKillInSeconds, ChronoUnit.SECONDS))) {
            LOGGER.debug("Ticket has expired because the difference between current time [{}] and ticket time [{}] is greater than or equal to [{}].", new Object[]{systemTime, lastTimeUsed, this.timeToKillInSeconds});
            return true;
        }
        return super.isExpired(ticketState);
    }

    protected ZonedDateTime getCurrentSystemTime() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public Long getTimeToIdle() {
        return 0L;
    }

    @Generated
    public MultiTimeUseOrTimeoutExpirationPolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiTimeUseOrTimeoutExpirationPolicy)) {
            return false;
        }
        MultiTimeUseOrTimeoutExpirationPolicy other = (MultiTimeUseOrTimeoutExpirationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.timeToKillInSeconds != other.timeToKillInSeconds) {
            return false;
        }
        return this.numberOfUses == other.numberOfUses;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultiTimeUseOrTimeoutExpirationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        result = result * 59 + this.numberOfUses;
        return result;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class ServiceTicketExpirationPolicy
    extends MultiTimeUseOrTimeoutExpirationPolicy {
        private static final long serialVersionUID = -5814201080268311070L;

        @JsonCreator
        public ServiceTicketExpirationPolicy(@JsonProperty(value="numberOfUses") int numberOfUses, @JsonProperty(value="timeToLive") long timeToKillInSeconds) {
            super(numberOfUses, timeToKillInSeconds);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class ProxyTicketExpirationPolicy
    extends MultiTimeUseOrTimeoutExpirationPolicy {
        private static final long serialVersionUID = -5814201080268311070L;

        @JsonCreator
        public ProxyTicketExpirationPolicy(@JsonProperty(value="numberOfUses") int numberOfUses, @JsonProperty(value="timeToLive") long timeToKillInSeconds) {
            super(numberOfUses, timeToKillInSeconds);
        }
    }
}

