/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.registry.EncodedTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTicketRegistry
implements TicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTicketRegistry.class);
    private static final String MESSAGE = "Ticket encryption is not enabled. Falling back to default behavior";
    protected CipherExecutor cipherExecutor;

    public <T extends Ticket> T getTicket(String ticketId, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(ticket.getClass())) {
            throw new ClassCastException("Ticket [" + ticket.getId() + " is of type " + ticket.getClass() + " when we were expecting " + clazz);
        }
        return (T)ticket;
    }

    public long sessionCount() {
        long l;
        block8: {
            Stream<Ticket> tgtStream = this.getTicketsStream().filter(TicketGrantingTicket.class::isInstance);
            Throwable throwable = null;
            try {
                l = tgtStream.count();
                if (tgtStream == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (tgtStream != null) {
                            AbstractTicketRegistry.$closeResource(throwable, tgtStream);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception t) {
                    LOGGER.trace("sessionCount() operation is not implemented by the ticket registry instance [{}]. Message is: [{}] Returning unknown as [{}]", new Object[]{this.getClass().getName(), t.getMessage(), Long.MIN_VALUE});
                    return Long.MIN_VALUE;
                }
            }
            AbstractTicketRegistry.$closeResource(throwable, tgtStream);
        }
        return l;
    }

    public long serviceTicketCount() {
        long l;
        block8: {
            Stream<Ticket> stStream = this.getTicketsStream().filter(ServiceTicket.class::isInstance);
            Throwable throwable = null;
            try {
                l = stStream.count();
                if (stStream == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (stStream != null) {
                            AbstractTicketRegistry.$closeResource(throwable, stStream);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception t) {
                    LOGGER.trace("serviceTicketCount() operation is not implemented by the ticket registry instance [{}]. Message is: [{}] Returning unknown as [{}]", new Object[]{this.getClass().getName(), t.getMessage(), Long.MIN_VALUE});
                    return Long.MIN_VALUE;
                }
            }
            AbstractTicketRegistry.$closeResource(throwable, stStream);
        }
        return l;
    }

    public int deleteTicket(String ticketId) {
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            LOGGER.trace("No ticket id is provided for deletion");
            return 0;
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            LOGGER.trace("Could not fetch ticket id [{}] form the registry", (Object)ticketId);
            return 0;
        }
        return this.deleteTicket(ticket);
    }

    public int deleteTicket(Ticket ticket) {
        AtomicInteger count = new AtomicInteger(0);
        if (ticket instanceof TicketGrantingTicket) {
            LOGGER.debug("Removing children of ticket [{}] from the registry.", (Object)ticket.getId());
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            count.addAndGet(this.deleteChildren(tgt));
            if (ticket instanceof ProxyGrantingTicket) {
                this.deleteProxyGrantingTicketFromParent((ProxyGrantingTicket)ticket);
            } else {
                this.deleteLinkedProxyGrantingTickets(count, tgt);
            }
        }
        LOGGER.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        if (this.deleteSingleTicket(ticket.getId())) {
            count.incrementAndGet();
        }
        return count.intValue();
    }

    protected int deleteTickets(Set<String> tickets) {
        return this.deleteTickets(tickets.stream());
    }

    protected int deleteTickets(Stream<String> tickets) {
        return tickets.mapToInt(this::deleteTicket).sum();
    }

    private void deleteLinkedProxyGrantingTickets(AtomicInteger count, TicketGrantingTicket tgt) {
        LinkedHashSet<String> pgts = new LinkedHashSet<String>(tgt.getProxyGrantingTickets().keySet());
        boolean hasPgts = !pgts.isEmpty();
        count.getAndAdd(this.deleteTickets(pgts));
        if (hasPgts) {
            LOGGER.debug("Removing proxy-granting tickets from parent ticket-granting ticket");
            tgt.getProxyGrantingTickets().clear();
            this.updateTicket((Ticket)tgt);
        }
    }

    private void deleteProxyGrantingTicketFromParent(ProxyGrantingTicket ticket) {
        ProxyGrantingTicket thePgt = ticket;
        thePgt.getTicketGrantingTicket().getProxyGrantingTickets().remove(thePgt.getId());
        this.updateTicket((Ticket)thePgt.getTicketGrantingTicket());
    }

    protected int deleteChildren(TicketGrantingTicket ticket) {
        AtomicInteger count = new AtomicInteger(0);
        Map services = ticket.getServices();
        if (services != null && !services.isEmpty()) {
            services.keySet().forEach(ticketId -> {
                if (this.deleteSingleTicket((String)ticketId)) {
                    LOGGER.debug("Removed ticket [{}]", ticketId);
                    count.incrementAndGet();
                } else {
                    LOGGER.debug("Unable to remove ticket [{}]", ticketId);
                }
            });
        }
        return count.intValue();
    }

    public abstract boolean deleteSingleTicket(String var1);

    protected String encodeTicketId(String ticketId) {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(MESSAGE);
            return ticketId;
        }
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return ticketId;
        }
        String encodedId = DigestUtils.sha512((String)ticketId);
        LOGGER.debug("Encoded original ticket id [{}] to [{}]", (Object)ticketId, (Object)encodedId);
        return encodedId;
    }

    protected Ticket encodeTicket(Ticket ticket) {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(MESSAGE);
            return ticket;
        }
        if (ticket == null) {
            LOGGER.debug("Ticket passed is null and cannot be encoded");
            return null;
        }
        LOGGER.debug("Encoding ticket [{}]", (Object)ticket);
        byte[] encodedTicketObject = SerializationUtils.serializeAndEncodeObject((CipherExecutor)this.cipherExecutor, (Serializable)ticket);
        String encodedTicketId = this.encodeTicketId(ticket.getId());
        EncodedTicket encodedTicket = new EncodedTicket(encodedTicketId, ByteSource.wrap((byte[])encodedTicketObject).read());
        LOGGER.debug("Created encoded ticket [{}]", (Object)encodedTicket);
        return encodedTicket;
    }

    protected Ticket decodeTicket(Ticket result) {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(MESSAGE);
            return result;
        }
        if (result == null) {
            LOGGER.warn("Ticket passed is null and cannot be decoded");
            return null;
        }
        if (!result.getClass().isAssignableFrom(EncodedTicket.class)) {
            LOGGER.warn("Ticket passed is not an encoded ticket type; rather it's a [{}], no decoding is necessary.", (Object)result.getClass().getSimpleName());
            return result;
        }
        LOGGER.debug("Attempting to decode [{}]", (Object)result);
        EncodedTicket encodedTicket = (EncodedTicket)result;
        Ticket ticket = (Ticket)SerializationUtils.decodeAndDeserializeObject((byte[])encodedTicket.getEncodedTicket(), (CipherExecutor)this.cipherExecutor, Ticket.class);
        LOGGER.debug("Decoded ticket to [{}]", (Object)ticket);
        return ticket;
    }

    protected Collection<Ticket> decodeTickets(Collection<Ticket> items) {
        return this.decodeTickets(items.stream()).collect(Collectors.toSet());
    }

    protected Stream<Ticket> decodeTickets(Stream<Ticket> items) {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(MESSAGE);
            return items;
        }
        return items.map(this::decodeTicket);
    }

    protected boolean isCipherExecutorEnabled() {
        return this.cipherExecutor != null && this.cipherExecutor.isEnabled();
    }

    @Generated
    public void setCipherExecutor(CipherExecutor cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    @Generated
    public AbstractTicketRegistry() {
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

