/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@Entity
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@Table(name="TRANSIENTSESSIONTICKET")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="TST")
public class TransientSessionTicketImpl
extends AbstractTicket
implements TransientSessionTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TransientSessionTicketImpl.class);
    private static final long serialVersionUID = 7839186396717950243L;
    @Lob
    @Column(name="SERVICE")
    private Service service;
    @Lob
    @Column(name="PROPERTIES", nullable=false)
    private HashMap<String, Serializable> properties = new HashMap();

    public TransientSessionTicketImpl(String id, ExpirationPolicy expirationPolicy, Service service) {
        super(id, expirationPolicy);
        this.service = service;
    }

    public TransientSessionTicketImpl(String id, ExpirationPolicy expirationPolicy, Service service, Map<String, Serializable> properties) {
        super(id, expirationPolicy);
        this.service = service;
        this.properties = new HashMap<String, Serializable>(properties);
    }

    public String getPrefix() {
        return "TST";
    }

    public void put(String name, Serializable value) {
        this.properties.put(name, value);
    }

    public void putAll(Map<String, Serializable> props) {
        this.properties.putAll(props);
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public <T extends Serializable> T get(String name, Class<T> clazz) {
        if (this.contains(name)) {
            return (T)((Serializable)clazz.cast(this.properties.get(name)));
        }
        return null;
    }

    public <T extends Serializable> T get(String name, Class<T> clazz, T defaultValue) {
        if (this.contains(name)) {
            return (T)((Serializable)clazz.cast(this.properties.getOrDefault(name, defaultValue)));
        }
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "TransientSessionTicketImpl(super=" + super.toString() + ", service=" + this.service + ", properties=" + this.properties + ")";
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public HashMap<String, Serializable> getProperties() {
        return this.properties;
    }

    @Generated
    public TransientSessionTicketImpl() {
    }

    @Generated
    public TransientSessionTicketImpl(Service service, HashMap<String, Serializable> properties) {
        this.service = service;
        this.properties = properties;
    }
}

