/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ProxyTicketImpl;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="PGT")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ProxyGrantingTicketImpl
extends TicketGrantingTicketImpl
implements ProxyGrantingTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyGrantingTicketImpl.class);
    private static final long serialVersionUID = -8126909926138945649L;

    public ProxyGrantingTicketImpl(String id, Authentication authentication, ExpirationPolicy policy) {
        super(id, authentication, policy);
    }

    @JsonCreator
    public ProxyGrantingTicketImpl(@JsonProperty(value="id") String id, @JsonProperty(value="proxiedBy") Service proxiedBy, @JsonProperty(value="ticketGrantingTicket") TicketGrantingTicket parentTicketGrantingTicket, @JsonProperty(value="authentication") Authentication authentication, @JsonProperty(value="expirationPolicy") ExpirationPolicy expirationPolicy) {
        super(id, proxiedBy, parentTicketGrantingTicket, authentication, expirationPolicy);
    }

    public ProxyTicket grantProxyTicket(String id, Service service, ExpirationPolicy expirationPolicy, boolean onlyTrackMostRecentSession) {
        ProxyTicketImpl serviceTicket = new ProxyTicketImpl(id, this, service, false, expirationPolicy);
        this.trackServiceSession(serviceTicket.getId(), service, onlyTrackMostRecentSession);
        return serviceTicket;
    }

    @Override
    public String getPrefix() {
        return "PGT";
    }

    @Generated
    public ProxyGrantingTicketImpl() {
    }
}

