/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractTicket
implements Ticket,
TicketState {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTicket.class);
    private static final long serialVersionUID = -8506442397878267555L;
    @Lob
    @Column(name="EXPIRATION_POLICY", length=0x7FFFFFFF, nullable=false)
    private ExpirationPolicy expirationPolicy;
    @Id
    @Column(name="ID", nullable=false)
    private String id;
    @Column(name="LAST_TIME_USED", length=0x7FFFFFFF)
    private ZonedDateTime lastTimeUsed;
    @Column(name="PREVIOUS_LAST_TIME_USED", length=0x7FFFFFFF)
    private ZonedDateTime previousTimeUsed;
    @Column(name="CREATION_TIME", length=0x7FFFFFFF)
    private ZonedDateTime creationTime;
    @Column(name="NUMBER_OF_TIMES_USED")
    private int countOfUses;
    @Column(name="EXPIRED", nullable=false)
    private Boolean expired = Boolean.FALSE;

    public AbstractTicket(@NonNull String id, @NonNull ExpirationPolicy expirationPolicy) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (expirationPolicy == null) {
            throw new NullPointerException("expirationPolicy is marked @NonNull but is null");
        }
        this.id = id;
        this.creationTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.lastTimeUsed = ZonedDateTime.now(ZoneOffset.UTC);
        this.expirationPolicy = expirationPolicy;
    }

    public void update() {
        this.previousTimeUsed = this.lastTimeUsed;
        this.lastTimeUsed = ZonedDateTime.now(ZoneOffset.UTC);
        ++this.countOfUses;
        if (this.getTicketGrantingTicket() != null && !this.getTicketGrantingTicket().isExpired()) {
            TicketState state = (TicketState)TicketState.class.cast(this.getTicketGrantingTicket());
            state.update();
        }
    }

    public boolean isExpired() {
        return this.expirationPolicy.isExpired((TicketState)this) || this.isExpiredInternal();
    }

    @JsonIgnore
    protected boolean isExpiredInternal() {
        return this.expired;
    }

    public int compareTo(Ticket o) {
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        return this.getId();
    }

    public Authentication getAuthentication() {
        return this.getTicketGrantingTicket().getAuthentication();
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        return null;
    }

    public void markTicketExpired() {
        this.expired = Boolean.TRUE;
    }

    @Generated
    public AbstractTicket() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTicket)) {
            return false;
        }
        AbstractTicket other = (AbstractTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastTimeUsed(ZonedDateTime lastTimeUsed) {
        this.lastTimeUsed = lastTimeUsed;
    }

    @Generated
    public void setPreviousTimeUsed(ZonedDateTime previousTimeUsed) {
        this.previousTimeUsed = previousTimeUsed;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setCountOfUses(int countOfUses) {
        this.countOfUses = countOfUses;
    }

    @Generated
    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    @Generated
    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    @Generated
    public ZonedDateTime getPreviousTimeUsed() {
        return this.previousTimeUsed;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public int getCountOfUses() {
        return this.countOfUses;
    }
}

