/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RemoteEndpointServiceAccessStrategy
extends DefaultRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteEndpointServiceAccessStrategy.class);
    private static final long serialVersionUID = -1108201604115278440L;
    private String endpointUrl;
    private String acceptableResponseCodes;

    @Override
    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> principalAttributes) {
        try {
            if (super.doPrincipalAttributesAllowServiceAccess(principal, principalAttributes)) {
                HttpResponse response = HttpUtils.executeGet((String)this.endpointUrl, (Map)CollectionUtils.wrap((String)"username", (Object)principal));
                Set currentCodes = StringUtils.commaDelimitedListToSet((String)this.acceptableResponseCodes);
                return response != null && currentCodes.contains(String.valueOf(response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    @Generated
    public String toString() {
        return "RemoteEndpointServiceAccessStrategy(super=" + super.toString() + ", endpointUrl=" + this.endpointUrl + ", acceptableResponseCodes=" + this.acceptableResponseCodes + ")";
    }

    @Generated
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Generated
    public String getAcceptableResponseCodes() {
        return this.acceptableResponseCodes;
    }

    @Generated
    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    @Generated
    public void setAcceptableResponseCodes(String acceptableResponseCodes) {
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    @Generated
    public RemoteEndpointServiceAccessStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteEndpointServiceAccessStrategy)) {
            return false;
        }
        RemoteEndpointServiceAccessStrategy other = (RemoteEndpointServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$endpointUrl = this.endpointUrl;
        String other$endpointUrl = other.endpointUrl;
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$acceptableResponseCodes = this.acceptableResponseCodes;
        String other$acceptableResponseCodes = other.acceptableResponseCodes;
        return !(this$acceptableResponseCodes == null ? other$acceptableResponseCodes != null : !this$acceptableResponseCodes.equals(other$acceptableResponseCodes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoteEndpointServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $endpointUrl = this.endpointUrl;
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $acceptableResponseCodes = this.acceptableResponseCodes;
        result = result * 59 + ($acceptableResponseCodes == null ? 43 : $acceptableResponseCodes.hashCode());
        return result;
    }
}

